% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ThetaClass.R
\name{Theta}
\alias{Theta}
\title{Create a new Theta instance with validation.}
\usage{
Theta(
  Name = character(),
  InitialEstimates = 1,
  State = "Present",
  Frozen = FALSE,
  StParmName = character(),
  PMLStructure = character()
)
}
\arguments{
\item{Name}{A character string representing the name of the Theta instance.}

\item{InitialEstimates}{An \code{\link[=InitialEstimate]{InitialEstimate()}} class instance or a numerical
value for the initial estimate of the Theta or a numeric vector length
three with its elements representing the lower bound, initial estimate.}

\item{State}{Character specifying the presence of the Theta. Possible values are:
\itemize{
\item \code{None} The Theta does not exist in the specified \code{PMLStructure}.
\item \code{Present} The Theta exists in the specified \code{PMLStructure} (the default)
\item \code{Searched} The presence of the Theta is searched.
}}

\item{Frozen}{A logical value indicating whether the Theta will be estimated or not.}

\item{StParmName}{A character specifying the corresponding structural
parameter name. Used for the \code{Name} of current Theta construction if it is not specified as 'tv' + \code{StParmName}.}

\item{PMLStructure}{PML structure current theta belongs to}
}
\value{
A Theta instance.
}
\description{
Create a new Theta instance with validation.
}
\examples{
# Create a new Theta instance with a name 'tvV' and initial value 2 (no bounds)
theta <- Theta(Name = "tvV", InitialEstimates = 2)

}
\seealso{
\code{\link[=InitialEstimate]{InitialEstimate()}} \code{\link[=StParm]{StParm()}}

Functions used for Theta specification: 
\code{\link{InitialEstimate}()},
\code{\link{create_ModelPD}()},
\code{\link{create_ModelPK}()},
\code{\link{modify_Theta}()}
}
\concept{Thetas}
