% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ovc_rccoor_distancia.R
\name{catr_ovc_get_rccoor_distancia}
\alias{catr_ovc_get_rccoor_distancia}
\title{OVCCoordenadas: Reverse geocode cadastral references on a region}
\usage{
catr_ovc_get_rccoor_distancia(lat, lon, srs = 4326, verbose = FALSE)
}
\arguments{
\item{lat}{Latitude to use on the query. It should be specified in the same
in the CRS/SRS \code{specified} by \code{srs}.}

\item{lon}{Longitude to use on the query. It should be specified in the same
in the CRS/SRS \code{specified} by \code{srs}.}

\item{srs}{SRS/CRS to use on the query. To check the admitted values check
\link{catr_srs_values}, specifically the \code{ovc_service} column.}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}
}
\value{
A tibble. See \strong{Details}
}
\description{
Implementation of the OVCCoordenadas service
\href{https://ovc.catastro.meh.es/ovcservweb/ovcswlocalizacionrc/ovccoordenadas.asmx?op=Consulta_RCCOOR_Distancia}{Consulta_RCCOOR_Distancia}.
Return the cadastral reference found on a set of coordinates. If no cadastral
references are found, the API returns a list of
the cadastral references found on an area of 50 square meters around the
requested coordinates.
}
\details{
When the API does not provide any result, the function returns a tibble with
the input parameters only.

On a successful query, the function returns a tibble with one row by
cadastral reference, including the following columns:
\itemize{
\item \code{geo.xcen}, \code{geo.ycen}, \code{geo.srs}: Input parameters of the query.
\item \code{refcat}: Cadastral Reference.
\item \code{address}: Address as it is recorded on the Cadastre.
\item \code{cmun_ine}: Municipality Code as registered on the INE (National
Statistics Institute).
\item Rest of fields: Check the API Docs on
\href{https://ovc.catastro.meh.es/ovcservweb/ovcswlocalizacionrc/ovccoordenadas.asmx?op=Consulta_RCCOOR_Distancia}{Consulta_RCCOOR_Distancia}
}
}
\examples{
\dontshow{if (tolower(Sys.info()[["sysname"]]) != "linux") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
catr_ovc_get_rccoor_distancia(
  lat = 40.963200,
  lon = -5.671420,
  srs = 4326
)
}
\dontshow{\}) # examplesIf}
}
\references{
\href{https://ovc.catastro.meh.es/ovcservweb/ovcswlocalizacionrc/ovccoordenadas.asmx?op=Consulta_RCCOOR_Distancia}{Consulta_RCCOOR_Distancia}
}
\seealso{
\link{catr_srs_values}, \code{vignette("ovcservice")}

OVCCoordenadas API:
\code{\link{catr_ovc_get_cpmrc}()},
\code{\link{catr_ovc_get_rccoor}()},
\code{\link{catr_srs_values}}

Other cadastral references: 
\code{\link{catr_ovc_get_cpmrc}()},
\code{\link{catr_ovc_get_rccoor}()}
}
\concept{OVCCoordenadas}
\concept{cadastral references}
