% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Adjust_raw.R
\name{Adjust_raw}
\alias{Adjust_raw}
\title{Adjusting raw p-values of a CTP}
\usage{
Adjust_raw(
  ctp.struc,
  p.value,
  dataset.name = NULL,
  factor.name = NULL,
  factor.levels = NULL,
  model = NULL,
  test.name = NULL
)
}
\arguments{
\item{ctp.struc}{Object generated by \code{\link{IntersectHypotheses}}}

\item{p.value}{vector of raw p-values in the order of the hypotheses created by \code{\link{summary.ctp.str}}}

\item{dataset.name}{Character string naming the analysis dataset (optional - only for documentation purposes).}

\item{factor.name}{Character string naming the factor whose levels are compared (optional - only for documentation purposes).}

\item{factor.levels}{Vector of type "character" containing the levels of the treatment factor 
(optional - only for documentation purposes).}

\item{model}{Model used in the analysis (optional - only for documentation purposes).}

\item{test.name}{Character string naming the statistical test applied.}
}
\value{
An object of \code{oldClass = "ctp"} to be used for summarizing and plotting the results.
}
\description{
Function that adjusts the raw p-values of a closed testing procedure. The raw p-values are adjusted according to the closure principle.
The adjusted p-value is calculated as the maximum of the raw p-value from the current hypothesis in question and the raw p-values from
all subsequent hypotheses that contain the current hypothesis.
}
\examples{

three.to.first <- IntersectHypotheses(list(1:2,c(1,3),c(1,4)))
Display(three.to.first)
summary(three.to.first)

# hyp.no level hypothesis.name 
#1      1     1            [12]
#2      2     1            [13]
#3      3     1            [14]
#4      1     2           [123]
#5      2     2           [124]
#6      3     2           [134]
#7      1     3          [1234]

# the vector of p-values calculated by another software

p.val <- c(0.05,0.04,0.02,0.08,0.03,0.03,0.04)

result <- Adjust_raw(ctp.struc=three.to.first, p.value=p.val)

# details may be documented

result <- Adjust_raw(ctp.struc=three.to.first, p.value=p.val
          ,dataset.name="mydata", factor.name="treatment"
          ,factor.levels=c("A","B","C","D"), model=y~treatment
          ,test.name="F")

summary(result)
Display(result)


}
\seealso{
\code{\link{IntersectHypotheses}}, \code{\link{AnalyseCTP}}, \code{\link{Display}},
\code{\link{summary.ctp}}
}
