% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CTM.R
\name{CDTM}
\alias{CDTM}
\title{Document Term Matrix}
\usage{
CDTM(doc, weighting, shortTermDeleted)
}
\arguments{
\item{doc}{The Chinese text document.}

\item{weighting}{Available weighting function with matrix are tf, tfidf.}

\item{shortTermDeleted}{Deltected short word when nchar <2.}
}
\description{
Constructs Document-Term Matrix from Chinese Text Documents.
}
\details{
This function run a Chinese word segmentation by jiebeR and build document-term matrix
and there is two weighting function with matrix,
term frequency and term frequency inverse document frequency.
}
\examples{
library(CTM)
a <- "hello taiwan"
b <- "world of tank"
c <- "taiwan weather"
d <- "local weather"
text <- t(data.frame(a,b,c,d))
dtm <- CDTM(doc = text, weighting = "tfidf", shortTermDeleted = FALSE)
}
\author{
Jim Liu
}

