% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_DynBiasCorrection.R
\name{CST_DynBiasCorrection}
\alias{CST_DynBiasCorrection}
\title{Performing a Bias Correction conditioned by the dynamical
properties of the data.}
\usage{
CST_DynBiasCorrection(
  exp,
  obs,
  method = "QUANT",
  wetday = FALSE,
  proxy = "dim",
  quanti,
  ncores = NULL
)
}
\arguments{
\item{exp}{an s2v_cube object with the experiment data}

\item{obs}{an s2dv_cube object with the reference data}

\item{method}{a character string indicating the method to apply bias 
correction among these ones: "PTF","RQUANT","QUANT","SSPLIN"}

\item{wetday}{logical indicating whether to perform wet day correction 
or not OR a numeric threshold below which all values are set to zero (by 
default is set to 'FALSE').}

\item{proxy}{a character string indicating the proxy for local dimension
'dim' or inverse of persistence 'theta' to apply the dynamical 
conditioned bias correction method.}

\item{quanti}{a number lower than 1 indicating the quantile to perform 
the computation of local dimension and theta}

\item{ncores}{The number of cores to use in parallel computation}
}
\value{
dynbias an s2dvcube object with a bias correction performed 
conditioned by local dimension 'dim' or inverse of persistence 'theta'
}
\description{
This function perform a bias correction conditioned by the 
dynamical properties of the dataset. This function internally uses the functions 
'Predictability' to divide in terciles the two dynamical proxies 
computed with 'CST_ProxiesAttractor'. A bias correction
between the model and the observations is performed using the division into
terciles of the local dimension 'dim' and inverse of the persistence 'theta'.
For instance, model values with lower 'dim' will be corrected with observed 
values with lower 'dim', and the same for theta. The function gives two options
of bias correction: one for 'dim' and/or one for 'theta'
}
\examples{
# example 1: simple data s2dvcube style
set.seed(1)
expL <- rnorm(1:2000)
dim (expL) <- c(time =100,lat = 4, lon = 5)
obsL <- c(rnorm(1:1980),expL[1,,]*1.2)
dim (obsL) <- c(time = 100,lat = 4, lon = 5)
time_obsL <- paste(rep("01", 100), rep("01", 100), 1920 : 2019, sep = "-")
time_expL <- paste(rep("01", 100), rep("01", 100), 1929 : 2019, sep = "-")
lon <- seq(-1,5,1.5)
lat <- seq(30,35,1.5)
# qm=0.98 # too high for this short dataset, it is possible that doesn't
# get the requirement, in that case it would be necessary select a lower qm
# for instance qm=0.60
expL <- s2dv_cube(data = expL, lat = lat, lon = lon,
                Dates = list(start = time_expL, end = time_expL))
obsL <- s2dv_cube(data = obsL, lat = lat, lon = lon,
                Dates = list(start = time_obsL, end = time_obsL))
# to use DynBiasCorrection
dynbias1 <- DynBiasCorrection(exp = expL$data, obs = obsL$data, proxy= "dim",
                                 quanti = 0.6)
# to use CST_DynBiasCorrection
dynbias2 <- CST_DynBiasCorrection(exp = expL, obs = obsL, proxy= "dim",
                                quanti = 0.6)

}
\references{
Faranda, D., Alvarez-Castro, M.C., Messori, G., Rodriguez, D., 
and Yiou, P. (2019). The hammam effect or how a warm ocean enhances large 
scale atmospheric predictability.Nature Communications, 10(1), 1316. 
DOI = https://doi.org/10.1038/s41467-019-09305-8 "

Faranda, D., Gabriele Messori and Pascal Yiou. (2017).
Dynamical proxies of North Atlantic predictability and extremes. 
Scientific Reports, 7-41278, 2017.
}
\author{
Carmen Alvarez-Castro, \email{carmen.alvarez-castro@cmcc.it}

Maria M. Chaves-Montero, \email{mdm.chaves-montero@cmcc.it}

Veronica Torralba, \email{veronica.torralba@cmcc.it}

Davide Faranda, \email{davide.faranda@lsce.ipsl.fr}
}
