% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_rfa_distseason.R
\name{ch_rfa_distseason}
\alias{ch_rfa_distseason}
\alias{ch_rfa_distseason.numeric}
\alias{ch_rfa_distseason.data.frame}
\alias{ch_rfa_distseason.formula}
\title{Distance in seasonal space}
\usage{
ch_rfa_distseason(x, ...)

\method{ch_rfa_distseason}{numeric}(x, a, w = 1/pi, ...)

\method{ch_rfa_distseason}{data.frame}(x, w = 1/pi, ...)

\method{ch_rfa_distseason}{formula}(form, x, w = 1/pi, ...)
}
\arguments{
\item{x, a}{Coordinates in the seasonal space. 
Can be a data.frame or vectors with radius \code{x} and angle \code{a}.}

\item{...}{Other parameters.}

\item{w}{Weight to favor angle over radius. 
By default it is 1/pi, which bring angle in the interval [0,1].}

\item{form}{Formula and dataset providing the coordinates of the
seasonal space. Must be of the form \code{radius ~ angle}.}
}
\value{
Returns a matrix of distances between points in the seasonal 
space that characterizes timing and regularity.
}
\description{
Calculates a matrix of distances between points in the seasonal 
space that characterizes timing and regularity.
It is equivalent to Euclidean distance applied to regularity (radius)
and timing (angle) separately.
}
\examples{

scoord <- data.frame(radius = runif(5), 
                     angle = runif(5,0,2*pi))

ch_rfa_distseason(radius ~ angle , scoord)


}
\references{
Durocher, M., Burn, D. H., & Ashkar, F. (2019). Comparison of estimation
  methods for a nonstationary index-flood model in flood frequency
  analysis using peaks over threshold. https://doi.org/10.31223/osf.io/rnepc
}
\seealso{
\link{ch_rfa_seasonstat}
}
\author{
Martin Durocher
}
