% Generated by roxygen2 (4.0.1): do not edit by hand
\name{decode.marginal}
\alias{decode.marginal}
\title{Decoding method using inference}
\usage{
decode.marginal(crf, infer.method, ...)
}
\arguments{
\item{crf}{The CRF}

\item{infer.method}{The inference method}

\item{...}{The parameters for \code{infer.method}}
}
\value{
This function will return the most likely configuration, which is a vector of length \code{crf$n.nodes}.
}
\description{
Computing the most likely configuration for CRF
}
\details{
Approximate decoding using inference (takes an inference method as input)
}
\examples{
library(CRF)
data(Small)
d <- decode.marginal(Small$crf, infer.exact)
}

