% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.CRABSset.R
\name{plot.CRABSset}
\alias{plot.CRABSset}
\title{Plots the rate functions}
\usage{
\method{plot}{CRABSset}(x, ...)
}
\arguments{
\item{x}{A list of congruent birth-death x}

\item{...}{other parameters}
}
\value{
a patchwork object object
}
\description{
Plots the rate functions
}
\examples{
data(primates_ebd)
lambda <- approxfun(primates_ebd$time, primates_ebd$lambda)
mu <- approxfun(primates_ebd$time, primates_ebd$mu)
times <- seq(0, max(primates_ebd$time), length.out = 500)

model <- create.model(lambda, mu, times = times)

mus <- list(function(t) 0.2 + exp(0.01*t), 
           function(t) 0.2 + sin(0.35*t) + 0.1*t,
           function(t) 1.0, 
           function(t) 0.5 + 0.2*t)
models <- congruent.models(model, mus = mus)

plot(models)
}
