% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihood.R
\name{crabs.loglikelihood}
\alias{crabs.loglikelihood}
\title{Compute likelihood}
\usage{
crabs.loglikelihood(phy, model, rho = 1)
}
\arguments{
\item{phy}{an object of class "phylo"}

\item{model}{an object of class "CRABS"}

\item{rho}{the taxon sampling fraction}
}
\value{
the log-likelihood of the tree given the model
}
\description{
Compute likelihood
}
\examples{
library(ape)
lambda <- function(t) exp(0.3*t) - 0.5*t
mu <- function(t) exp(0.3*t) - 0.2*t - 0.8
 
model <- create.model(lambda, mu, times = seq(0, 3, by = 0.005))

set.seed(123)
phy <- rcoal(25)

crabs.loglikelihood(phy, model)
}
