% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screen_units.R
\name{Screen.data.frame}
\alias{Screen.data.frame}
\title{Screen units based on data availability}
\usage{
\method{Screen}{data.frame}(
  x,
  id_col = NULL,
  unit_screen,
  dat_thresh = NULL,
  nonzero_thresh = NULL,
  Force = NULL,
  ...
)
}
\arguments{
\item{x}{A data frame}

\item{id_col}{Name of column of the data frame to be used as the identifier, e.g. normally this would be \code{uCode}
for indicator data sets used in coins. This must be specified if \code{Force} is specified.}

\item{unit_screen}{Specifies whether and how to screen units based on data availability or zero values.
\itemize{
\item If set to \code{"byNA"}, screens units with data availability below \code{dat_thresh}
\item If set to \code{"byzeros"}, screens units with non-zero values below \code{nonzero_thresh}
\item If set to \code{"byNAandzeros"}, screens units based on either of the previous two criteria being true.
}}

\item{dat_thresh}{A data availability threshold (\verb{>= 1} and \verb{<= 0}) used for flagging low data and screening units if \code{unit_screen != "none"}. Default 0.66.}

\item{nonzero_thresh}{As \code{dat_thresh} but for non-zero values. Defaults to 0.05, i.e. it will flag any units with less than 5\% non-zero values (equivalently more than 95\% zero values).}

\item{Force}{A data frame with any additional units to force inclusion or exclusion. Required columns \code{uCode}
(unit code(s)) and \code{Include} (logical: \code{TRUE} to include and \code{FALSE} to exclude). Specifications here override
exclusion/inclusion based on data rules.}

\item{...}{arguments passed to or from other methods.}
}
\value{
Missing data stats and screened data as a list.
}
\description{
Screens units (rows) based on a data availability threshold and presence of zeros. Units can be optionally
"forced" to be included or excluded, making exceptions for the data availability threshold.
}
\details{
The two main criteria of interest are \code{NA} values, and zeros. The summary table gives percentages of
\code{NA} values for each unit, across indicators, and percentage zero values (\emph{as a percentage of non-\code{NA} values}).
Each unit is flagged as having low data or too many zeros based on thresholds.

See also \code{vignette("screening")}.
}
\examples{
# example data
iData <- ASEM_iData[40:51, c("uCode", "Research", "Pat", "CultServ", "CultGood")]

# screen to 75\% data availability (by row)
l_scr <- Screen(iData, unit_screen = "byNA", dat_thresh = 0.75)

# summary of screening
head(l_scr$DataSummary)

}
