% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{i_mean_grp}
\alias{i_mean_grp}
\title{Impute by group mean}
\usage{
i_mean_grp(x, f)
}
\arguments{
\item{x}{A numeric vector}

\item{f}{A grouping variable, of the same length of \code{x}, that specifies the group that each value
of \code{x} belongs to. This will be coerced to a factor.}
}
\value{
A numeric vector
}
\description{
Replaces \code{NA}s in a numeric vector with the grouped arithmetic means of the non-\code{NA} values.
Groups are defined by the \code{f} argument.
}
\examples{
x <- c(NA, runif(10), NA)
f <- c(rep("a", 6), rep("b", 6))
i_mean_grp(x, f)

}
