% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfuncs.R
\name{qTreat.purse}
\alias{qTreat.purse}
\title{Quick outlier treatment of a purse}
\usage{
\method{qTreat}{purse}(
  x,
  dset,
  winmax = 5,
  skew_thresh = 2,
  kurt_thresh = 3.5,
  f2 = "log_CT",
  ...
)
}
\arguments{
\item{x}{A purse}

\item{dset}{Name of data set to treat for outliers in each coin}

\item{winmax}{Maximum number of points to Winsorise for each indicator. Default 5.}

\item{skew_thresh}{Absolute skew threshold - default 2.}

\item{kurt_thresh}{Kurtosis threshold - default 3.5.}

\item{f2}{Function to call if Winsorisation does not bring skew and kurtosis within limits. Default \code{"log_CT"}.}

\item{...}{arguments passed to or from other methods.}
}
\value{
An updated purse
}
\description{
A simplified version of \code{\link[=Treat]{Treat()}} which allows direct access to the default parameters. This has less flexibility,
but is an easier interface and probably more convenient if the objective is to use the default treatment process
but with some minor adjustments.
}
\details{
This function simply applies the same data treatment to each coin. See documentation for \code{\link[=Treat.coin]{Treat.coin()}},
\code{\link[=qTreat.coin]{qTreat.coin()}} and \code{vignette("treat")}.
}
\examples{
#
}
