% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_assemble.R
\name{replaceDF}
\alias{replaceDF}
\title{Replace multiple values in a data frame}
\usage{
replaceDF(df, lookup)
}
\arguments{
\item{df}{A data frame or a vector}

\item{lookup}{A data frame with columns \code{old} (the values to be replaced) and \code{new} the values to replace with. See details.}
}
\value{
A data frame with replaced values
}
\description{
Given a data frame (or vector), this function replaces values according to a look up table or dictionary. In COINr this may
be useful for exchanging categorical data with numeric scores, prior to assembly. Or for changing codes.
}
\details{
The lookup data frame must not have any duplicated values in the \code{old} column. This function looks for exact matches of
elements of the \code{old} column and replaces them with the corresponding value in the \code{new} column. For each row of \code{lookup},
the class of the old value must match the class of the new value. This is to keep classes of data frames columns consistent.
If you wish to replace with a different class, you should convert classes in your data frame before using this function.
}
\examples{
# replace sub-pillar codes in ASEM indicator metadata
codeswap <- data.frame(old = c("Conn", "Sust"), new = c("SI1", "SI2"))
# swap codes in both indmeta and aggmeta
replaceDF(ASEMIndMeta, codeswap)
replaceDF(ASEMAggMeta, codeswap)

}
\seealso{
\itemize{
\item \code{\link[=assemble]{assemble()}} Assemble a COIN - this function optionally calls \code{\link[=extractYear]{extractYear()}}.
\item \code{\link[=rankDF]{rankDF()}} Replace numeric columns of a data frame with ranks.
\item \code{\link[=roundDF]{roundDF()}} Replace numeric columns of a data frame with rounded values.
\item \code{\link[=compareDF]{compareDF()}} Detailed comparison of two similar data frames.
}
}
