% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_s3generics_clvfittedtransactions_plot.R
\name{plot.clv.fitted.transactions}
\alias{plot.clv.fitted.transactions}
\alias{plot}
\alias{plot,clv.fitted.transactions-method}
\title{Plot Diagnostics for a Fitted Transaction Model}
\usage{
\method{plot}{clv.fitted.transactions}(
  x,
  which = c("tracking", "pmf"),
  other.models = list(),
  prediction.end = NULL,
  cumulative = FALSE,
  trans.bins = 0:9,
  calculate.remaining = TRUE,
  label.remaining = "10+",
  newdata = NULL,
  transactions = TRUE,
  label = NULL,
  plot = TRUE,
  verbose = TRUE,
  ...
)

\S4method{plot}{clv.fitted.transactions}(
  x,
  which = c("tracking", "pmf"),
  other.models = list(),
  prediction.end = NULL,
  cumulative = FALSE,
  trans.bins = 0:9,
  calculate.remaining = TRUE,
  label.remaining = "10+",
  newdata = NULL,
  transactions = TRUE,
  label = NULL,
  plot = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{The fitted transaction model for which to produce diagnostic plots}

\item{which}{Which plot to produce, either "tracking" or "pmf". May be abbreviated but only one may be selected. Defaults to "tracking".}

\item{other.models}{List of fitted transaction models to plot. List names are used as colors, standard colors are chosen if unnamed (see examples).
The \code{clv.data} object stored in each model is used if no \code{newdata} is given.}

\item{prediction.end}{"tracking": Until what point in time to plot. This can be the number of periods (numeric) or a form of date/time object. See details.}

\item{cumulative}{"tracking": Whether the cumulative expected (and actual) transactions should be plotted.}

\item{trans.bins}{"pmf": Vector of positive integer numbers (>=0) indicating the number of repeat transactions (x axis) to plot. Should contain 0 in nearly all cases as it refers to repeat-transactions.}

\item{calculate.remaining}{"pmf": Whether the probability for the remaining number of transactions not in \code{trans.bins} should be calculated.}

\item{label.remaining}{"pmf": Label for the last bar, if \code{calculate.remaining=TRUE}.}

\item{newdata}{An object of class clv.data for which the plotting should be made with the fitted model.
If none or NULL is given, the plot is made for the data on which the model was fit.
If \code{other.models} was specified, the data in each model is replaced with \code{newdata}.}

\item{transactions}{Whether the actual observed repeat transactions should be plotted.}

\item{label}{Character vector to label each model. If NULL, the model(s) internal name is used (see examples).}

\item{plot}{Whether a plot is created or only the assembled data is returned.}

\item{verbose}{Show details about the running of the function.}

\item{...}{Ignored}
}
\value{
An object of class \code{ggplot} from package \code{ggplot2} is returned by default.
If \code{plot=FALSE}, the data that would have been used to create the plot is returned.
Depending on which plot was selected, this is a data.table which contains the
following columns:

For the Tracking plot:
\item{period.until}{The timepoint that marks the end (up until and including) of the period to which the data in this row refers.}
\item{variable}{Type of variable that 'value' refers to. Either "model name" or "Actual" (if \code{transactions=TRUE}).}
\item{value}{Depending on variable either (Actual) the actual number of repeat transactions in the period that ends at \code{period.until},
or the unconditional expectation for the period that ends on \code{period.until} ("model name").}

For the PMF plot:
\item{num.transactions}{The number of repeat transactions in the estimation period (as ordered factor).}
\item{variable}{Type of variable that 'value' refers to. Either "model name" or "Actual" (if \code{transactions=TRUE}).}
\item{value}{Depending on variable either (Actual) the actual number of customers which have the respective number of repeat transactions,
or the number of customers which are expected to have the respective number of repeat transactions, as by the fitted model ("model name").}
}
\description{
Depending on the value of parameter \code{which}, one of the following plots will be produced.
See \code{\link[CLVTools:plot.clv.data]{plot.clv.data}} to plot more nuanced diagnostics for the transaction data only.
For comparison, other models can be drawn into the same plot by specifying them in \code{other.models} (see examples).


\subsection{Tracking Plot}{
Plot the actual repeat transactions and overlay it with the repeat transaction as predicted
by the fitted model. Currently, following previous literature, the in-sample unconditional
expectation is plotted in the holdout period. In the future, we might add the option to also
plot the summed CET for the holdout period as an alternative evaluation metric.
Note that only whole periods can be plotted and that the prediction end might not exactly match \code{prediction.end}.
See the Note section for more details.
}

\subsection{PMF Plot}{
Plot the actual and expected number of customers which made a given number of repeat
transaction in the estimation period. The expected number is based on the PMF of the fitted model,
the probability to make exactly a given number of repeat transactions in the estimation period.
For each bin, the expected number is the sum of all customers' individual PMF value.
Note that if \code{trans.bins} is changed, \code{label.remaining} needs to be adapted as well.

}
}
\details{
\code{prediction.end} indicates until when to predict or plot and can be given as either
a point in time (of class \code{Date}, \code{POSIXct}, or \code{character}) or the number of periods.
If \code{prediction.end} is of class character, the date/time format set when creating the data object is used for parsing.
If \code{prediction.end} is the number of periods, the end of the fitting period serves as the reference point
from which periods are counted. Only full periods may be specified.
If \code{prediction.end} is omitted or NULL, it defaults to the end of the holdout period if present and to the
end of the estimation period otherwise.

The first prediction period is defined to start right after the end of the estimation period.
If for example weekly time units are used and the estimation period ends on Sunday 2019-01-01, then the first day
of the first prediction period is Monday 2019-01-02. Each prediction period includes a total of 7 days and
the first prediction period therefore will end on, and include, Sunday 2019-01-08. Subsequent prediction periods
again start on Mondays and end on Sundays.
If \code{prediction.end} indicates a timepoint on which to end, this timepoint is included in the prediction period.

The \code{newdata} argument has to be a clv data object of the exact same class as the data object
on which the model was fit. In case the model was fit with covariates, \code{newdata} needs to contain identically
named covariate data.

The use case for \code{newdata} is mainly two-fold: First, to estimate model parameters only on a
sample of the data and then use the fitted model object to predict or plot for the full data set provided through \code{newdata}.
Second, for models with dynamic covariates, to provide a clv data object with longer covariates than contained in the data
on which the model was estimated what allows to predict or plot further. When providing \code{newdata}, some models
might require additional steps that can significantly increase runtime.
}
\note{
Because the unconditional expectation for a period is derived as the difference of
the cumulative expectations calculated at the beginning and at end of the period,
all timepoints for which the expectation is calculated are required to be spaced exactly 1 time unit apart.

If \code{prediction.end} does not coincide with the start of a time unit, the last timepoint
for which the expectation is calculated and plotted therefore is not \code{prediction.end}
but the start of the first time unit after \code{prediction.end}.
}
\examples{
\donttest{

data("cdnow")

# Fit ParetoNBD model on the CDnow data
clv.cdnow <- clvdata(cdnow, time.unit="w",
                           estimation.split=37,
                           date.format="ymd")
pnbd.cdnow <- pnbd(clv.cdnow)

## TRACKING PLOT
# Plot actual repeat transaction, overlayed with the
#  expected repeat transactions as by the fitted model
plot(pnbd.cdnow)

# Plot cumulative expected transactions of only the model
plot(pnbd.cdnow, cumulative=TRUE, transactions=FALSE)

# Plot until 2001-10-21
plot(pnbd.cdnow, prediction.end = "2001-10-21")

# Plot until 2001-10-21, as date
plot(pnbd.cdnow,
     prediction.end = lubridate::dym("21-2001-10"))

# Plot 15 time units after end of estimation period
plot(pnbd.cdnow, prediction.end = 15)

# Save the data generated for plotting
#   (period, actual transactions, expected transactions)
plot.out <- plot(pnbd.cdnow, prediction.end = 15)

# A ggplot object is returned that can be further tweaked
library("ggplot2")
gg.pnbd.cdnow <- plot(pnbd.cdnow)
gg.pnbd.cdnow + ggtitle("PNBD on CDnow")


## PMF PLOT
plot(pnbd.cdnow, which="pmf")

# For transactions 0 to 15, also have
#  to change label for remaining
plot(pnbd.cdnow, which="pmf", trans.bins=0:15,
     label.remaining="16+")

# For transactions 0 to 15 bins, no remaining
plot(pnbd.cdnow, which="pmf", trans.bins=0:15,
     calculate.remaining=FALSE)

## MODEL COMPARISON
# compare vs bgnbd
bgnbd.cdnow <- bgnbd(clv.cdnow)
ggomnbd.cdnow <- ggomnbd(clv.cdnow)

# specify colors as names of other.models
# note that ggomnbd collapses into the pnbd on this dataset
plot(pnbd.cdnow, cumulative=TRUE,
     other.models=list(blue=bgnbd.cdnow, "#00ff00"=ggomnbd.cdnow))

# specify names as label, using standard colors
plot(pnbd.cdnow, which="pmf",
     other.models=list(bgnbd.cdnow),
     label=c("Pareto/NBD", "BG/NBD"))
}

}
\seealso{
\code{\link[CLVTools:plot.clv.fitted.spending]{plot.clv.fitted.spending}} for diagnostics of spending models

\code{\link[CLVTools:plot.clv.data]{plot.clv.data}} for transaction diagnostics of \code{clv.data} objects

\code{\link[CLVTools:pmf]{pmf}} for the values on which the PMF plot is based
}
