# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Exponentiation function for integer arguments
#'
#' Solaris' compiler freaked hard on the pow function---couldn't figure
#' out whether it should return an int or a float or something, when
#' I used it to get very small powers of two. So I
#' am going to write a silly, simple function (that only gets used a couple
#' of times in an entire execution, and only with very
#' small arguments, so the fact that it is not super efficient
#' should not be a big problem).
#' @param x the integer to raise 2 to.
#' @name int_pow2
#' @keywords internal
NULL

#' Depth first search down the pedigree to N generations.
#'
#' When you call this
#' from within search_up(), c should be set at 0,
#' and the algorithm will run down for, n generations from there.
#' Unlike in R, this is 0-based.  So, n = 0 is self, n = 1 is kids,
#' n = 2 is grandkids, and so forth.
#' @param i the index of the node to call this on
#' @param c the current generation level.  0 = the first (i.e. the starting individual).
#' @param n the number of generations back to down.  1 means go no further than the offspring.
#' 2 means go no further than the grandkids.
#' @param P the pedigree structure
#' @param C a reference to a character vector to which sampled individuals' IDs will get
#' pushed on.  At the end, we can unique them.
#' @name search_down
#' @keywords internal
NULL

#' Depth first search up the pedigree to N generations.
#'
#' Call this
#' with c = 0 for the original individual, and it will go back, n generations.
#' Unlike in R, this is 0-based.  So, n = 1 is parents, n = 2 is grandparents
#' and so on.
#' @param i the index of the node to call this on
#' @param c the current generation level.  0 = the first (i.e. the sampled individual)
#' @param n the number of generations back to go.  1 means go no further than the parents.
#' 2 means go no further than the grandparents.
#' @param P the pedigree structure
#' @param C a reference to a character vector to which sampled individuals' IDs will get
#' pushed on.  At the end, we can unique them.
#' @name search_up
#' @keywords internal
NULL

#' Function to make a vector of all the ancestors of an individual out to n generations.
#'
#' This is a replacement for the R implementation of
#' `ancestor_vectors()` which was too slow. This will get called
#' from with a C function in which the pedigree has been assembled.
#' @param sv vector of sample indexes
#' @param nv vector of names of all samples
#' @param Ped pedigree struct
#' @param n the number of generations.  0 = self, 1 = parent, 2 = grandparent, etc.
#' @name ancestor_vectors_cpp
#' @keywords internal
NULL

#' function to test and use DFS stuff
#' @param L list of inputs
#' @param n the number of generations back to go when computing the ancestor vectors
#' and finding relatives.
#' @keywords internal
#' @export
rcpp_ancestors_and_relatives <- function(L, n) {
    .Call('_CKMRpop_rcpp_ancestors_and_relatives', PACKAGE = 'CKMRpop', L, n)
}

#' Return a list of the indices of the primary shared ancestors
#'
#' This operates on an ancestry match matrix and uses a simple, divide-by_two
#' relationship between an ancestor and its descendants in the ordering
#' of an ancestry vector to determine which of the matching ancestors are secondary,
#' and then return the ones that are primary.
#' @param M an ancestry match matrix (it is a logical matrix)
#' @return A list of pairs.  Each pair is the 1-based index of ancestor of ind_1, then
#' ind_2 of the primary shared ancestors.
#' @keywords internal
#' @export
#' @examples
#' # find primary ancestor pairs of example AMMs
#' lapply(example_amms, primary_ancestor_pairs)
primary_ancestor_pairs <- function(M) {
    .Call('_CKMRpop_primary_ancestor_pairs', PACKAGE = 'CKMRpop', M)
}

recursive_push_back <- function(Boing, i) {
    invisible(.Call('_CKMRpop_recursive_push_back', PACKAGE = 'CKMRpop', Boing, i))
}

rcpp_test <- function(v1) {
    .Call('_CKMRpop_rcpp_test', PACKAGE = 'CKMRpop', v1)
}

