% Generated by roxygen2 (4.0.2): do not edit by hand
\name{lbsSearchAuthors}
\alias{lbsSearchAuthors}
\title{Find authors that satisfy given criteria}
\usage{
lbsSearchAuthors(conn, names.like = NULL, group = NULL)
}
\arguments{
\item{conn}{connection object, see \code{\link{lbsConnect}}.}

\item{names.like}{character vector of SQL-LIKE patterns to match authors' names.}

\item{group}{character vector of author group identifiers.}
}
\value{
Integer vector of authors' identifiers which match at least one of given
SQL-LIKE patterns.
}
\description{
Finds authors by name.
}
\details{
\code{names.like} is a set of search patterns in an SQL \code{LIKE} format,
i.e. an underscore \code{_} matches a single character and a percent sign
\code{\%} matches any set of characters. The search is case-insensitive.
}
\examples{
\dontrun{
conn <- dbBiblioConnect("Bibliometrics.db");
## ...
id <- lbsSearchAuthors(conn, c("Smith\\\%", "Knuth D.E.", "V_n \\\%"));
lbsGetInfoAuthors(conn, id);
## ...}
}
\seealso{
\code{\link{lbsGetInfoAuthors}},
\code{\link{lbsSearchDocuments}},
\code{\link{lbsGetInfoDocuments}},\cr
\code{\link{lbsFindDuplicateAuthors}}
}

