% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minDepth.R
\name{MinDepth}
\alias{MinDepth}
\title{Calculate Variable Importance}
\usage{
MinDepth(cerfit)
}
\arguments{
\item{cerfit}{A fitted CERFIT object}
}
\value{
Returns a named vector with the name of each predictor used to fit the CERFIT
object and its corresponding average minimal depth across all trees
}
\description{
Calculates the average minimal depth of each predictor used to fit
a CERFIT object. It calculates Variables importance by using a Variables average minimal depth.
variable's with a lower average minimal depth are more important.
}
\details{
The depth of the root node is zero and if a variable does not appear
at any split in a tree it is assigned maxdepth + 1 for that tree.
}
\examples{
fit <- CERFIT(Result_of_Treatment ~ sex + age + Number_of_Warts + Area + Time + Type | treatment,
data = warts,
ntrees = 30,
method = "RCT",
mtry = 2)
importance <- MinDepth(fit)
}
