#' vulnerability-class
#'
#' An object of class \code{vulnerability} is created from a \code{cnfa} object
#' and a \code{dep} object.
#'
#' @slot call Original function call
#' @slot vf vulnerability factor
#' @slot vulnerability Magnitude of the vulnerability factor
#' @slot ras RasterLayer of vulnerability values
#' @slot weights Raster layer of weights used for departure calculation
#'
#' @export

setClass("vulnerability", slots = list(call = "call", vf = "numeric", vulnerability = "numeric", ras = "Raster", weights = "Raster"))

setMethod("show",
          signature = "vulnerability",
          function(object){
            if (!inherits(object, "vulnerability"))
              stop("Object of class 'vulnerability' expected")
            cat("CLIMATIC VULNERABILITY")
            cat("\n\nVulnerability factor: \n")
            print(round(object@vf, 2))
            cat("\nOverall vulnerability: ")
            cat(signif(object@vulnerability, 4))
          }
)
