% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parCov.R
\name{parCov}
\alias{parCov}
\alias{parCov,Raster,missing-method}
\alias{parCov,Raster,Raster-method}
\title{Efficient calculation of covariance matrices for Raster* objects}
\usage{
parCov(x, y, ...)

\S4method{parCov}{Raster,missing}(
  x,
  w = NULL,
  sample = TRUE,
  progress = FALSE,
  parallel = FALSE,
  n = 1,
  cl = NULL,
  keep.open = FALSE
)

\S4method{parCov}{Raster,Raster}(
  x,
  y,
  w = NULL,
  sample = TRUE,
  progress = FALSE,
  parallel = FALSE,
  n = 1,
  cl = NULL,
  keep.open = FALSE
)
}
\arguments{
\item{x}{Raster* object, typically a brick or stack}

\item{y}{NULL (default) or a Raster* object with the same extent and resolution
as \code{x}}

\item{...}{additional arguments, including any of the following:}

\item{w}{optional Raster* object of weights for a weighted covariance matrix}

\item{sample}{logical. If \code{TRUE}, the sample covariance is calculated
with a denominator of $n-1$}

\item{progress}{logical. If \code{TRUE}, messages and progress bar will be
printed}

\item{parallel}{logical. If \code{TRUE} then multiple cores are utilized}

\item{n}{numeric. Number of CPU cores to utilize for parallel processing}

\item{cl}{optional cluster object}

\item{keep.open}{logical. If \code{TRUE} and \code{parallel = TRUE}, the
cluster object will not be closed after the function has finished}
}
\value{
Returns a matrix with the same row and column names as the layers of
  \code{x}. If \code{y} is supplied, then the covariances between the layers
  of \code{x} and the layers of code{y} are computed.
}
\description{
\code{parCov} efficiently calculates the covariance of Raster* objects,
taking advantage of parallel processing and pulling data into memory only as
necessary. For large datasets with lots of variables, calculating the covariance
matrix rapidly becomes unwieldy, as the number of calculations required grows
quadratically with the number of variables.
}
\details{
This function is designed to work similarly to the
  \code{\link[stats]{cov}} and the \code{\link[raster]{layerStats}}
  functions, with two major differences. First, \code{parCov} allows you to
  calculate the covariance between two different Raster* objects, whereas
  \code{layerStats} does not. Second, \code{parCov} can (optionally) compute
  each element of the covariance matrix in parallel, offering a dramatic
  improvement in computation time for large Raster* objects.

  The raster layer of weights \code{w} should contain raw weights as values,
  and should \emph{not} be normalized so that \code{sum(w) = 1}. This is
  necessary for computing the sample covariance, whose formula contains
  \code{sum(w) - 1} in its denominator.
}
\examples{
mat1 <- parCov(climdat.hist)

# correlation matrix
Z <- parScale(climdat.hist)
mat2 <- parCov(Z)

# covariance between two Raster* objects
mat3 <- parCov(x = climdat.hist, y = climdat.fut)

}
\seealso{
\code{\link[stats]{cov}}, \code{\link[raster]{layerStats}}
}
