% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binaryBenchmarkFunctions.R
\name{benchmarkGeneratorNKL}
\alias{benchmarkGeneratorNKL}
\title{NK-Landscape Benchmark Creation}
\usage{
benchmarkGeneratorNKL(N = 10, K = 1, PI = 1:K, g = NULL)
}
\arguments{
\item{N}{length of the bit strings}

\item{K}{number of neighbours contributing to fitness of one position}

\item{PI}{vector, giving relative positions of each neighbour in the bit-string}

\item{g}{set of fitness functions for each possible combination of string components. Will be randomly determined if not specified. Should have N rows, and 2^(K+1) columns.}
}
\value{
the function of type cost=f(bitstring). Returned fitness values will be negative, for purpose of minimization.
}
\description{
Function that generates a NK-Landscapes.
}
\examples{
fun <- benchmarkGeneratorNKL(6,2)
fun(c(1,0,1,1,0,0))
fun(c(1,0,1,1,0,1))
fun(c(0,1,0,0,1,1))
fun <- benchmarkGeneratorNKL(6,3)
fun(c(1,0,1,1,0,0))
fun <- benchmarkGeneratorNKL(6,2,c(-1,1))
fun(c(1,0,1,1,0,0))
fun <- benchmarkGeneratorNKL(6,2,c(-1,1),g=matrix(runif(48),6))
fun(c(1,0,1,1,0,0))
fun(sample(c(0,1),6,TRUE))

}

