% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database.R
\name{save_tags}
\alias{save_tags}
\title{Save Document Tags}
\usage{
save_tags(uri_fun, user, password, host, port, database, tag_vect)
}
\arguments{
\item{uri_fun}{Uniform resource identifier (URI) string generating function for MongoDB credentials.}

\item{user}{MongoDB user name.}

\item{password}{MongoDB user password.}

\item{host}{MongoDB host server.}

\item{port}{MongoDB port.}

\item{database}{MongoDB database name.}

\item{tag_vect}{Character vector of 10 tag names.}
}
\value{
{
MongoDB operation results.
}
}
\description{
Save name of EHR document metadata tags. Individual notes or parts of notes can be labelled with up to 10 tags, typically the patient's name at the time, the type of note, the note section, the author, etc. Tags are not mandatory.
}
\examples{
\dontrun{
save_tags(uri_fun = mongo_uri_standard, user = 'John', password = 'db_password_1234',
host = 'server1234', port = NA, database = 'TEST_PROJECT',
tag_vect = c('note_type', 'note_section', 'author', 'patient_name', NA, NA, NA, NA, NA, NA))
}
}
