% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{create_Stations}
\alias{create_Stations}
\title{Create Stations}
\usage{
create_Stations(
  Poly,
  Bathy,
  Depths,
  N = NA,
  Nauto = NA,
  dist = NA,
  Buf = 1000,
  ShowProgress = FALSE
)
}
\arguments{
\item{Poly}{single polygon inside which stations will be generated. May be created using \code{\link{create_Polys}}.}

\item{Bathy}{bathymetry raster with the appropriate \code{\link[CCAMLRGIS:CCAMLRp]{projection}}, such as \code{\link[CCAMLRGIS:SmallBathy]{this one}}.}

\item{Depths}{numeric, vector of depths. For example, if the depth strata required are 600 to 1000 and 1000 to 2000,
\code{Depths=c(-600,-1000,-2000)}.}

\item{N}{numeric, vector of number of stations required in each depth strata,
therefore \code{length(N)} must equal \code{length(Depths)-1}.}

\item{Nauto}{numeric, instead of specifying \code{N}, a number of stations proportional to the areas of the depth strata
may be created. \code{Nauto} is the maximum number of stations required in any depth stratum.}

\item{dist}{numeric, if desired, a distance constraint in nautical miles may be applied. For example, if \code{dist=2},
stations will be at least 2 nautical miles apart.}

\item{Buf}{numeric, distance in meters from isobaths. Useful to avoid stations falling on strata boundaries.}

\item{ShowProgress}{logical, if set to \code{TRUE}, a progress bar is shown (\code{create_Stations} may take a while).}
}
\value{
Spatial object in your environment. Data within the resulting object contains the strata and stations
locations in both projected space ("x" and "y") and decimal degrees of Latitude/Longitude.

To see the data contained in your spatial object, type: \code{View(MyStations)}.
}
\description{
Create random point locations inside a polygon and within bathymetry strata constraints.
A distance constraint between stations may also be used if desired.
}
\examples{
\donttest{

# For more examples, see:
# https://github.com/ccamlr/CCAMLRGIS#22-create-stations

#First, create a polygon within which stations will be created
MyPoly=create_Polys(
 data.frame(Name="mypol",
            Latitude=c(-75,-75,-70,-70),
            Longitude=c(-170,-180,-180,-170))
 ,Densify=TRUE)

par(mai=c(0,0,0,0))
plot(st_geometry(Coast[Coast$ID=='88.1',]),col='grey')
plot(st_geometry(MyPoly),col='green',add=TRUE)
text(MyPoly$Labx,MyPoly$Laby,MyPoly$ID)

#Create a set numbers of stations, without distance constraint:
library(terra)
#optional: crop your bathymetry raster to match the extent of your polygon
BathyCroped=crop(rast(SmallBathy),ext(MyPoly))

#Create stations
MyStations=create_Stations(MyPoly,BathyCroped,Depths=c(-2000,-1500,-1000,-550),N=c(20,15,10))

#add custom colors to the bathymetry to indicate the strata of interest
MyCols=add_col(var=c(-10000,10000),cuts=c(-2000,-1500,-1000,-550),cols=c('blue','cyan'))
plot(BathyCroped,breaks=MyCols$cuts,col=MyCols$cols,legend=FALSE,axes=FALSE)
add_Cscale(height=90,fontsize=0.75,width=16,lwd=0.5,
offset=-130,cuts=MyCols$cuts,cols=MyCols$cols)
plot(st_geometry(MyPoly),add=TRUE,border='red',lwd=2,xpd=TRUE)
plot(st_geometry(MyStations),add=TRUE,col='orange',cex=0.75,lwd=1.5,pch=3)


}

}
\seealso{
\code{\link{create_Polys}}, \code{\link{SmallBathy}}.
}
