% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4-BuyseTest.vcov.R
\docType{methods}
\name{S4BuyseTest-vcov}
\alias{S4BuyseTest-vcov}
\alias{vcov,S4BuyseTest-method}
\title{Extract Uncertainty from GPC}
\usage{
\S4method{vcov}{S4BuyseTest}(
  object,
  endpoint = NULL,
  statistic = NULL,
  strata = FALSE,
  cumulative = TRUE,
  ...
)
}
\arguments{
\item{object}{a \code{S4BuyseTest} object, output of \code{\link{BuyseTest}}.}

\item{endpoint}{[character] for which endpoint(s) the variance-covariance matrix should be output?
If \code{NULL} consider all endpoints.}

\item{statistic}{[character] the type of summary statistic. See the detail section.}

\item{strata}{[character vector] the strata relative to which the variance-covariance matrix should be output.
Can also be \code{"global"} or \code{FALSE} to output the statistic pooled over all strata.}

\item{cumulative}{[logical] should the summary statistic be cumulated over endpoints?
Otherwise display the contribution of each endpoint.}

\item{...}{ignored.}
}
\value{
A numeric matrix.
}
\description{
Extract uncertainty about the summary statistics (net benefit, win ratio, ...) from GPC.
}
\details{
When consider a second order H-decomposition, it is only used to estimate variance: the correlation between endpoints is evaluated using the first order H-decomposition.
}
\author{
Brice Ozenne
}
\keyword{method}
