% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenotype.R
\name{phenotype}
\alias{phenotype}
\title{Evaluate the phenotypic value}
\usage{
phenotype(sEnv = NULL, plotType = "Standard", nRep = 1,
  popID = NULL, locations = 1, years = NULL)
}
\arguments{
\item{sEnv}{the environment that BSL functions operate in. Default is "simEnv" so use that to avoid specifying when calling functions}

\item{plotType}{links to previously defined error variance and cost (default: "Standard")}

\item{nRep}{scalar: the number of replications per trial (i.e., year x loc combination) (default: 1)}

\item{popID}{population ID to be evaluated (default: the latest population)}

\item{locations}{integer vector of the locations where phenotyping occurs (e.g., c(1, 3) to phenotype at locations 1 and 3. Default: 1, phenotype at the first location)}

\item{years}{integer vector of the years when phenotyping occurs (e.g., 1:2 to phenotype during the first two years of the breeding scheme. Default: the last year among previous phenotyping. NOTE: thus, to phenotype in a new [the next] year, specify the next year number [e.g., if past phenotyping was in years 1 & 2, specify 3]).}
}
\value{
modifies the list sims in environment sEnv by generating phenotypes for the specified popID, locations, and years.
}
\description{
Evaluate the phenotypic value
}
\seealso{
\code{\link{defineSpecies}} for an example
}
