% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defineSpecies.R
\name{defineSpecies}
\alias{defineSpecies}
\title{Define and create species}
\usage{
defineSpecies(loadData = NULL, importFounderHap = NULL,
  saveDataFileName = NULL, nSim = 1, nCore = 1, nChr = 7,
  lengthChr = 150, effPopSize = 100, nMarkers = 1000, nQTL = 50,
  propDomi = 0, nEpiLoci = 0, domModel = "HetHom")
}
\arguments{
\item{loadData}{if null create a new species (default), else the file name of previously created species like "species1_1" (Do not put "RData" extension). A path can be specified, like "simDirectory/species1_1" (in which case "simDirectory" must exist).}

\item{importFounderHap}{if null create new founder haplotypes (default), else the file name of externally sourced founder haplotypes in hapmap format (see Manual).  If founder haplotypes are loaded, the `nMarkers` parameter is superseded by the number of loci in those haplotypes.}

\item{saveDataFileName}{if not NULL, the name to save the species data, like "species1_1". A path can be specified, like "simDirectory/species1_1" (in which case "simDirectory" must exist). Default: NULL}

\item{nSim}{the number of simulation trials}

\item{nCore}{simulation processed in parallel over this number of CPUs (Check computer capacity before setting above 1.)}

\item{nChr}{the number of chromosomes}

\item{lengthChr}{the length of each chromosome (cM. all chromosomes are the same length)}

\item{effPopSize}{the effective population size in the base population}

\item{nMarkers}{the number of markers, which is used especially for genomic selection}

\item{nQTL}{the number of QTLs controlling the target trait}

\item{propDomi}{the probability of dominant QTL among the all QTL}

\item{nEpiLoci}{the expected number of epistatic loci for each effect}

\item{domModel}{the dominance model: "HetHom" means homozygotes have equal effect but opposite to that of heterozygotes, "Partial": zero means ancestral dominant over derived, one means derived dominant over ancestral, any value in between means partial dominance. At the moment, functionality for the "Partial" option is only available when using ImportFounderHap.}
}
\value{
An environment that contains a list sims with each object of the list being one replicate to initiate a simulation
}
\description{
Define and create species
}
\examples{
if (exists("simEnv")){
rm(list=names(simEnv), envir=simEnv)
rm(simEnv)
}
simEnv <- defineSpecies(nSim=2, nChr=5, lengthChr=100, effPopSize=20, nMarkers=100, nQTL=10)
initializePopulation(nInd=50) # popID 0 created
phenotype()
select(nSelect=20) # popID 1 selected out of popID 0
cross() # popID 2 created
phenotype(nRep=2)
select(nSelect=5) # popID 3 selected out of popID 2
cross() # popID 4 created
plotData()

}
