% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{fitfvbm}
\alias{fitfvbm}
\title{Maximum pseudolikelihood estimation of a fully-visible Boltzmann machine.}
\usage{
fitfvbm(data, bvec, Mmat, delta_crit = 0.001, max_it = 1000L)
}
\arguments{
\item{data}{An N by n matrix, where each of the N rows contains a length n string of spin variables  (i.e. each element is -1 or 1).}

\item{bvec}{Initial estimate for a vector of length n containing real valued bias parameters.}

\item{Mmat}{Initial estimate for a symmetric n by n matrix, with zeros along the diagonal, containing the interaction parameters.}

\item{delta_crit}{Real threshold value for the convergence criterion, based on the relative change in the Euclidean distance of parameter estimates from consecutive iterations.}

\item{max_it}{Integer value indicating the maximum number of iterations that the algorithm is to run for.}
}
\value{
A list containing 4 objects: the final log-pseudolikelihood value \code{pll}, a vector containing the estimate of the bias parameters \code{bvec}, a matrix containing the estimate of the interaction parameters \code{Mmat}, and the number of algorithm iterations \code{itt}.
}
\description{
Estimates the bias vector and interaction matrix of a fully-visible Boltzmann machine via maximum pseudolikelihood estimation using an MM algorithm.
}
\examples{
# Generate num=1000 random strings of n=3 binary spin variables under bvec and Mmat.
num <- 1000
bvec <- c(0,0.5,0.25)
Mmat <- matrix(0.1,3,3) - diag(0.1,3,3)
data <- rfvbm(num,bvec,Mmat)
# Fit a fully visible Boltzmann machine to data, starting from parameters bvec and Mmat.
fitfvbm(data,bvec,Mmat)
}
\references{
H.D. Nguyen and I.A. Wood (2016), A block successive lower-bound maximization algorithm for the maximum pseudolikelihood estimation of fully visible Boltzmann machines, Neural Computation, vol 28, pp. 485-492
}
\author{
Andrew T. Jones and Hien D. Nguyen
}
