% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{fvbmstderr}
\alias{fvbmstderr}
\title{Standard errors for the parameter elements of a fitted fully-visible Boltzmann machine.}
\usage{
fvbmstderr(data, covarmat)
}
\arguments{
\item{data}{An N by n matrix, where each of the N rows contains a length n string of spin variables  (i.e. each element is -1 or 1).}

\item{covarmat}{A covariance matrix generated from \code{fvbmcov}.}
}
\value{
A list containing 2 objects: a vector containing the standard errors corresponding to the bias parameters \code{bvec_se}, and a matrix containing the standard errors corresponding to the interaction parameters \code{Mmat_se}.
}
\description{
Computes the normal approximation standard errors from the sandwich estimator of the covariance matrix for a maximum pseudolikelihood estimated fully-visible Boltzmann machine.
}
\examples{
# Generate num=1000 random strings of n=3 binary spin variables under bvec and Mmat.
}
\references{
H.D. Nguyen and I.A. Wood (2016), Asymptotic normality of the maximum pseudolikelihood estimator for fully-visible Boltzmann machines, IEEE Transactions on Neural Networks and Learning Systems, vol. 27, pp. 897-902.
}
\author{
Andrew T. Jones and Hien D. Nguyen
num <- 1000
bvec <- c(0,0.5,0.25)
Mmat <- matrix(0.1,3,3) - diag(0.1,3,3)
data <- rfvbm(num,bvec,Mmat)
# Fit a fully visible Boltzmann machine to data, starting from parameters bvec and Mmat.
model <- fitfvbm(data,bvec,Mmat)
# Compute the sandwich covariance matrix using the data and the model.
covarmat <- fvbmcov(data,model,fvbmHess)
# Compute the standard errors of the parameter elements according to a normal approximation.
fvbmstderr(data,covarmat)
}
