\name{removeNAcomm}
\alias{removeNAcomm}
\alias{removeNAenv}
\alias{same.sites}
\alias{check.datasets}
\alias{check.ordiscores}
\alias{removezerospecies}
\alias{subsetcomm}


\title{Synchronize Community and Environmental Datasets}

\description{
These functions may assist to ensure that the sites of the community dataset are the same sites as those from the environmental dataset, something that is assumed to be the case for the \pkg{BiodiversityR} and \pkg{vegan} packages.
}

\usage{
same.sites(x,y)
check.datasets(x,y)
check.ordiscores(x,ord,check.species=T)
removeNAcomm(x,y,variable)
removeNAenv(x,variable)
removezerospecies(x)
subsetcomm(x,y,factor,level,returncomm=T)
}

\arguments{
  \item{x}{ Data frame assumed to be the community dataset with variables corresponding to species. }
  \item{y}{ Data frame assumed to be the environmental dataset with variables corresponding to descriptors of sites. }
  \item{ord}{ Ordination result. }
  \item{check.species}{ Should the species scores be checked (TRUE) or not. }
  \item{variable}{ Name of the variable from the environmental dataset with NA values that indicate those sites that should be removed. }
  \item{factor}{ Variable of the environmental data frame that defines subsets to calculate diversity statistics for. }
  \item{level}{ Level of the variable to create the subset to calculate diversity statistics. }
  \item{returncomm}{ For the selected sites, return the community dataset (TRUE) or the environmental dataset. }
}

\details{
Function \code{same.sites} provides a new data frame that has the same row names as the row names of the environmental data set and the same (species) variables as the original community data set. Sites from the original community data set that have no corresponding sites in the environmental data set are not included in the new community data set. (Hint: this function can be especially useful when some sites do not contain any species and where a community dataset was generated by the \code{\link{makecommunitydataset}} function.) 
 
Function \code{check.datasets} checks whether the community and environmental data sets have the same number of rows, and (if this was the case) whether the rownames of both data sets are the same. The function also returns the dimensions of both data sets.
 
Function \code{check.ordiscores} checks whether the community data set and the ordination result have the same number of rows (sites) and columns (species, optional for \code{check.species==TRUE}), and (if this was the case) whether the row and column names of both data sets are the same. Site and species scores for the ordination result are obtained via function \code{\link[vegan]{scores}} (\pkg{vegan}).
 
Functions \code{removeNAcomm} and \code{removeNAenv} provide a new data frame that does not contain \code{NA} for the specified variable. The specifed variable is part of the environmental data set. These functions are particularly useful when using community and environmental datasets, as new community and environmental datasets can be calculated that contain information from the same sample plots (sites). An additional result of \code{removeNAenv} is that factor levels of any categorical variable that do not occur any longer in the new data set are removed from the levels of the categorical variable.
 
Function \code{removezerospecies} removes species from a community dataset that have total abundance that is smaller or equal to zero.

Function \code{subsetcomm} makes a subset of sites that contain a specified level of a categorical variable from the environmental data set. The same functionality of selecting subsets of the community or environmental data sets are implemented in various functions of \pkg{BiodiversityR} (for example \code{\link{diversityresult}}, \code{\link{renyiresult}} and \code{\link{accumresult}}) and have the advantage that it is not necessary to create a new data set. If a community dataset is returned, species that did not contain any individuals were removed from the data set. If an environmental dataset is returned, factor levels that did not occur were removed from the data set.
 
}

\value{
The functions return a data frame or results of tests on the correspondence between community and environmental data sets.
}

\references{
Kindt, R. & Coe, R. (2005) 
Tree diversity analysis: A manual and
  software for common statistical methods for ecological and
  biodiversity studies.
 
  \url{http://www.worldagroforestry.org/treesandmarkets/tree_diversity_analysis.asp} }   

\author{Roeland Kindt (World Agroforestry Centre)}

\examples{
library(vegan)
data(dune.env)
data(dune)
dune.env2 <- dune.env
dune.env2[1:4,"Moisture"] <- NA
dune2 <- removeNAcomm(dune,dune.env2,"Moisture")
dune.env2 <- removeNAenv(dune.env2,"Moisture")
dune3 <- same.sites(dune,dune.env2)
check.datasets(dune,dune.env2)
check.datasets(dune2,dune.env2)
check.datasets(dune3,dune.env2)
dune4 <- subsetcomm(dune,dune.env,"Management","NM",returncomm=TRUE)
dune.env4 <- subsetcomm(dune,dune.env,"Management","NM",returncomm=FALSE)
dune5 <- same.sites(dune,dune.env4)
check.datasets(dune4,dune5)
}

\keyword{multivariate} 


