% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BigVARObjectClass.R
\docType{class}
\name{BigVAR-class}
\alias{BigVAR-class}
\title{BigVAR Object Class}
\description{
An object class to be used with cv.BigVAR
}
\details{
To construct an object of class BigVAR, use the function \code{\link{constructModel}}
}
\section{Slots}{

\describe{
\item{\code{Data}}{a \eqn{T \times k} multivariate time Series}

\item{\code{lagmax}}{Maximal lag order for modeled series}

\item{\code{Structure}}{Penalty Structure}

\item{\code{Relaxed}}{Indicator for relaxed VAR}

\item{\code{Granularity}}{Granularity of Penalty Grid}

\item{\code{horizon}}{Desired Forecast Horizon}

\item{\code{crossval}}{Cross-Validation Procedure}

\item{\code{Minnesota}}{Minnesota Prior Indicator}

\item{\code{verbose}}{Indicator for Verbose output}

\item{\code{dates}}{dates extracted from an xts object}

\item{\code{ic}}{Indicator for including AIC and BIC benchmarks}

\item{\code{VARX}}{VARX Model Specifications}

\item{\code{T1}}{Index of time series in which to start cross validation}

\item{\code{T2}}{Index of times series in which to start forecast evaluation}

\item{\code{ONESE}}{Indicator for "One Standard Error Heuristic"}

\item{\code{ownlambdas}}{Indicator for user-supplied lambdas}

\item{\code{tf}}{Indicator for transfer function}

\item{\code{alpha}}{Grid of candidate alpha values (applies only to Sparse VARX-L models)}

\item{\code{recursive}}{Indicator as to whether recursive multi-step forecasts are used (applies only to multiple horizon VAR models)}

\item{\code{constvec}}{vector indicating variables to shrink toward a random walk instead of toward zero (valid only if Minnesota is \code{TRUE})}
}}

\seealso{
\code{\link{constructModel}}
}
