% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpys.R
\name{rpys}
\alias{rpys}
\title{Create a spectrogram using data from the free software CRExplorer}
\usage{
rpys(df, py1, py2, col_cr = "red", col_med = "blue",
  smoothing = TRUE, par_pch = 20, plot_NCR = TRUE, plot_Med = TRUE,
  ...)
}
\arguments{
\item{df}{data frame with reference publication year, number of cited references, and median deviation as exported from the CRExplorer (File > Export > CSV (Graph)).}

\item{py1}{determines lowest reference publication year which should be shown in the graph.}

\item{py2}{determines highest reference publication year which should be shown in the graph.}

\item{col_cr}{character color name value to determine color of the line and points of the number of cited references (optional parameter). The default value is "red".}

\item{col_med}{character color name value to determine color of the line and points of the median deviation (optional parameter). The default value is "blue".}

\item{smoothing}{boolean variable (optional parameter) which determines if the lines of the spectrogram are smoothed or not.
(T: yes apply smoothing, F: no do not apply smoothing). The default value is T.}

\item{par_pch}{integer value to set the point type (optional parameter). The default value is 20.}

\item{plot_NCR}{boolean variable (optional parameter) which determines the NCR curve should be plotted.}

\item{plot_Med}{boolean variable (optional parameter) which determines the median deviation curve should be plotted.}

\item{...}{additional arguments to pass to the \link{plot}, \link{points}, and \link{lines} functions.}
}
\description{
Provide the contents of the CSV file from the 'CRExplorer' in a data frame, e.g. df,
and the function call rpys(df, py1, py2) creates the spectrogram.
Here, py1 and py2 are the lowest and highest publication year to be used in the plot.
The function rpys takes some optional arguments to modify its behaviour, see arguments and details.
}
\details{
rpys(df=data_frame, py1=integer_value, py2=integer_value, smoothing=boolean, col_cr=character_color_name, col_med=character_color_name, par_pch=integer, plot_NCR=boolean, plot_Med=boolean, ...)
Only the arguments df, py1, and py2 are necessary. All other aruments are optional.

Literature:

- Thor, A., Bornmann, L., Marx, W., Haunschild, R., Leydesdorff, L., & Mutz, Ruediger (2017). Website of the free software 'CRExplorer', http://www.crexplorer.net

An example data frame is provided as \code{rpys_example_data} in the package. It can be used to create an example spectrogram.
}
\examples{

data(rpys_example_data)

rpys(rpys_example_data, 1935, 2010)

}
