% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBNfns.R
\name{compact2full}
\alias{compact2full}
\title{Deriving an adjecency matrix of a full DBN}
\usage{
compact2full(DBNmat, n.dynamic, n.slices, n.static = 0)
}
\arguments{
\item{DBNmat}{a square matrix, representing initial and transitional structure of a DBN; the size of matrix is 2*n.dynamic+n.static}

\item{n.dynamic}{integer, number of dynamic variables in one time slice}

\item{n.slices}{integer, number of slices in an unrolled DBN}

\item{n.static}{integer, number of static variables}
}
\value{
an adjacency matrix of an unrolled DBN
}
\description{
This function transforms a compact 2-slice adjacency matrix of DBN into full T-slice adjacency matrix
}
\examples{
compact2full(DBNmat, n.dynamic=12, n.slices=5, n.static=3)
}
