% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBeeGUTS.R
\name{plot.beeSurvValidation}
\alias{plot.beeSurvValidation}
\title{Plotting method for \code{beeSurvValidation} objects}
\usage{
\method{plot}{beeSurvValidation}(
  x,
  ...,
  xlab = "Time [d]",
  ylab1 = "Number of survivors",
  ylab2 = "Concentration",
  main = paste("Validation results for a BeeGUTS", x$typeData, "calibrated for",
    x$beeSpecies)
)
}
\arguments{
\item{x}{An object of class \code{beeSurvValid}}

\item{...}{Additional parameters to generic plot functions (not used)}

\item{xlab}{A character string for the label of the x-axis}

\item{ylab1}{A character string for the label of the y-axis of the survivor plots}

\item{ylab2}{A character string for the label of the y-axis of the concentration plots}

\item{main}{A character string for the title label plot}
}
\value{
A graphic with the results of the validation
}
\description{
This is the generic \code{plot} S3 method for the \code{beeSurvValid}
class. It plots the number of survivors as a function of time as well as the reconstructed
concentrations for \code{"Acute_Oral"} and \code{"Acute_Contact"} test types.
}
\examples{
\donttest{
data(betacyfluthrinChronic) # Load dataset for validation
data(fitBetacyfluthrin_Chronic)
validation <- validate(fitBetacyfluthrin_Chronic, betacyfluthrinChronic)
plot(validation)
}
}
