/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.trace;

import dr.inference.trace.LogFileTraces;
import dr.inference.trace.TraceException;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.Reportable;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class GeneralizedHarmonicMeanAnalysis
implements Reportable {
    public static final String GENERALIZED_HARMONIC_MEAN_ANALYSIS = "generalizedHarmonicMeanAnalysis";
    public static final String RESULT_FILE_NAME = "resultsFileName";
    public static final String SOURCE_COLUMN = "sourceColumn";
    public static final String DESTINATION_COLUMN = "destinationColumn";
    public static final String FORMAT = "%5.5g";
    private final String sourceName;
    private final String destinationName;
    private final List<Double> sourceSample;
    private final List<Double> destinationSample;
    private boolean logBayesFactorCalculated = false;
    private double logBayesFactor;
    private List<Double> maxLogLikelihood;
    private List<Double> mlContribution;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new StringAttributeRule("fileName", "The traceName of a BEAST log file (can not include trees, which should be logged separately)"), new StringAttributeRule("resultsFileName", "The name of the output file to which the generalized stepping-stone sampling estimate will be written", true), new ElementRule("sourceColumn", new XMLSyntaxRule[]{new StringAttributeRule("name", "The column name")}), new ElementRule("destinationColumn", new XMLSyntaxRule[]{new StringAttributeRule("name", "The column name")})};

        @Override
        public String getParserName() {
            return GeneralizedHarmonicMeanAnalysis.GENERALIZED_HARMONIC_MEAN_ANALYSIS;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            String string = xMLObject.getStringAttribute("fileName");
            String string2 = null;
            if (xMLObject.hasAttribute(GeneralizedHarmonicMeanAnalysis.RESULT_FILE_NAME)) {
                string2 = xMLObject.getStringAttribute(GeneralizedHarmonicMeanAnalysis.RESULT_FILE_NAME);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n = stringTokenizer.countTokens();
            System.out.println(n + " file(s) found with marginal likelihood samples");
            try {
                Object object;
                Object object2;
                String string3 = "";
                String string4 = "";
                List<Double> list = null;
                List<Double> list2 = null;
                for (int i = 0; i < n; ++i) {
                    object2 = new File(stringTokenizer.nextToken());
                    object = ((File)object2).getName();
                    String string5 = ((File)object2).getParent();
                    if (!((File)object2).isAbsolute()) {
                        string5 = string5 == null ? System.getProperty("user.dir") : Paths.get(System.getProperty("user.dir"), string5).toString();
                    }
                    String string6 = System.getProperty("file.name.prefix");
                    String string7 = System.getProperty("file.separator");
                    if (string6 != null) {
                        if (string6.trim().length() == 0 || string6.contains(string7)) {
                            throw new XMLParseException("The specified file name prefix is illegal.");
                        }
                        object2 = new File(string5, string6 + (String)object);
                    } else {
                        object2 = new File(string5, (String)object);
                    }
                    string = ((File)object2).getAbsolutePath();
                    XMLObject xMLObject2 = xMLObject.getChild(GeneralizedHarmonicMeanAnalysis.SOURCE_COLUMN);
                    string3 = xMLObject2.getStringAttribute("name");
                    xMLObject2 = xMLObject.getChild(GeneralizedHarmonicMeanAnalysis.DESTINATION_COLUMN);
                    string4 = xMLObject2.getStringAttribute("name");
                    LogFileTraces logFileTraces = new LogFileTraces(string, (File)object2);
                    logFileTraces.loadTraces();
                    long l = 0L;
                    logFileTraces.setBurnIn(l);
                    int n2 = -1;
                    int n3 = -1;
                    for (int j = 0; j < logFileTraces.getTraceCount(); ++j) {
                        String string8 = logFileTraces.getTraceName(j);
                        if (string8.trim().equals(string3)) {
                            n2 = j;
                        }
                        if (!string8.trim().equals(string4)) continue;
                        n3 = j;
                    }
                    if (n2 == -1) {
                        throw new XMLParseException("Column '" + string3 + "' can not be found for " + this.getParserName() + " element.");
                    }
                    if (n3 == -1) {
                        throw new XMLParseException("Column '" + string4 + "' can not be found for " + this.getParserName() + " element.");
                    }
                    if (list == null && list2 == null) {
                        list = logFileTraces.getValues(n2);
                        list2 = logFileTraces.getValues(n3);
                        continue;
                    }
                    list.addAll(logFileTraces.getValues(n2));
                    list2.addAll(logFileTraces.getValues(n3));
                }
                GeneralizedHarmonicMeanAnalysis generalizedHarmonicMeanAnalysis = new GeneralizedHarmonicMeanAnalysis(string3, string4, list, list2);
                System.out.println(generalizedHarmonicMeanAnalysis.toString());
                if (string2 != null) {
                    object2 = new FileWriter(string2, true);
                    object = new BufferedWriter((Writer)object2);
                    ((Writer)object).write(generalizedHarmonicMeanAnalysis.toString());
                    ((BufferedWriter)object).flush();
                    ((BufferedWriter)object).close();
                }
                return generalizedHarmonicMeanAnalysis;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new XMLParseException("File '" + string + "' can not be opened for " + this.getParserName() + " element.");
            }
            catch (IOException iOException) {
                throw new XMLParseException(iOException.getMessage());
            }
            catch (TraceException traceException) {
                throw new XMLParseException(traceException.getMessage());
            }
        }

        @Override
        public String getParserDescription() {
            return "Performs a trace analysis.";
        }

        @Override
        public Class getReturnType() {
            return GeneralizedHarmonicMeanAnalysis.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public GeneralizedHarmonicMeanAnalysis(String string, String string2, List<Double> list, List<Double> list2) {
        this.sourceName = string;
        this.destinationName = string2;
        this.sourceSample = list;
        this.destinationSample = list2;
    }

    public double getLogBayesFactor() {
        if (!this.logBayesFactorCalculated) {
            this.calculateBF();
        }
        return this.logBayesFactor;
    }

    private void calculateBF() {
        this.logBayesFactor = 0.0;
        if (this.sourceSample.size() != this.destinationSample.size()) {
            throw new RuntimeException("Error in GeneralizedHarmonicMeanAnalysis: source and destination samples have different numbers of entries.");
        }
        int n = this.sourceSample.size();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < n; ++i) {
            double d = this.destinationSample.get(i) * (1.0 - this.sourceSample.get(i) / this.destinationSample.get(i));
            arrayList.add(d);
        }
        double d = (Double)arrayList.get(0);
        double d2 = 1.0;
        for (int i = 1; i < arrayList.size(); ++i) {
            System.out.println("internalSum = " + (d2 += Math.exp((Double)arrayList.get(i) - d)));
        }
        System.out.println("\nlog(size) = " + StrictMath.log(n));
        System.out.println("-firstPart = " + -d);
        System.out.println("-Math.log(internalSum) = " + -Math.log(d2));
        this.logBayesFactor = StrictMath.log(n) - d - Math.log(d2);
        this.logBayesFactorCalculated = true;
    }

    public String toString() {
        double d = this.getLogBayesFactor();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nlog marginal likelihood (using generalized harmonic mean) from (" + this.sourceName + " - " + this.destinationName + ") = " + d + "\n");
        return stringBuffer.toString();
    }

    @Override
    public String getReport() {
        return this.toString();
    }
}

