/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchmodel.lineagespecific;

import dr.inference.distribution.ParametricMultivariateDistributionModel;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import java.util.ArrayList;
import java.util.List;

public class DirichletProcessPrior
extends AbstractModelLikelihood {
    private static boolean VERBOSE = false;
    private Parameter categoriesParameter;
    private CompoundParameter uniquelyRealizedParameters;
    public ParametricMultivariateDistributionModel baseModel;
    private Parameter gamma;
    private int categoryCount;
    private int N;
    private boolean likelihoodKnown = false;
    private double logLikelihood;
    private final List<Double> cachedLogFactorials;

    public DirichletProcessPrior(Parameter parameter, CompoundParameter compoundParameter, ParametricMultivariateDistributionModel parametricMultivariateDistributionModel, Parameter parameter2) {
        super("");
        this.categoriesParameter = parameter;
        this.baseModel = parametricMultivariateDistributionModel;
        this.uniquelyRealizedParameters = compoundParameter;
        this.gamma = parameter2;
        this.categoryCount = compoundParameter.getDimension();
        this.N = parameter.getDimension();
        this.cachedLogFactorials = new ArrayList<Double>();
        this.cachedLogFactorials.add(0, 0.0);
        this.addVariable(this.categoriesParameter);
        this.addVariable(this.gamma);
        this.addVariable(this.uniquelyRealizedParameters);
        if (parametricMultivariateDistributionModel != null) {
            this.addModel(parametricMultivariateDistributionModel);
        }
        this.likelihoodKnown = false;
    }

    private double getLogFactorial(int n) {
        if (this.cachedLogFactorials.size() <= n) {
            for (int i = this.cachedLogFactorials.size() - 1; i <= n; ++i) {
                double d = this.cachedLogFactorials.get(i) + Math.log(i + 1);
                this.cachedLogFactorials.add(d);
            }
        }
        return this.cachedLogFactorials.get(n);
    }

    private int[] getCounts() {
        int[] nArray = new int[this.categoryCount];
        for (int i = 0; i < this.N; ++i) {
            int n;
            int n2 = n = this.getMapping(i);
            nArray[n2] = nArray[n2] + 1;
        }
        return nArray;
    }

    public double getGamma() {
        return this.gamma.getParameterValue(0);
    }

    private int getMapping(int n) {
        return (int)this.categoriesParameter.getParameterValue(n);
    }

    public double getLogDensity(Parameter parameter) {
        double[] dArray = (double[])parameter.getAttributeValue();
        return this.baseModel.logPdf(dArray);
    }

    public double getRealizedValuesLogDensity() {
        double d = 0.0;
        for (int i = 0; i < this.categoryCount; ++i) {
            Parameter parameter = this.uniquelyRealizedParameters.getParameter(i);
            d += this.getLogDensity(parameter);
        }
        return d;
    }

    public double getCategoriesLogDensity() {
        int n;
        int[] nArray = this.getCounts();
        if (VERBOSE) {
            // empty if block
        }
        double d = (double)this.categoryCount * Math.log(this.getGamma());
        for (n = 0; n < this.categoryCount; ++n) {
            int n2 = nArray[n];
            if (n2 <= 0) continue;
            d += this.getLogFactorial(n2 - 1);
        }
        for (n = 1; n <= this.N; ++n) {
            d -= Math.log(this.getGamma() + (double)n - 1.0);
        }
        return d;
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        this.fireModelChanged();
        this.likelihoodKnown = false;
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.calculateLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    private double calculateLogLikelihood() {
        double d = this.getCategoriesLogDensity() + this.getRealizedValuesLogDensity();
        return d;
    }

    @Override
    public void makeDirty() {
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.likelihoodKnown = false;
    }

    public int getCategoryCount() {
        return this.categoryCount;
    }

    public Parameter getUniqueParameters() {
        return this.uniquelyRealizedParameters;
    }

    public Parameter getUniqueParameter(int n) {
        return this.uniquelyRealizedParameters.getParameter(n);
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.categoriesParameter) {
            this.fireModelChanged();
        } else if (variable == this.gamma) {
            this.fireModelChanged();
        } else if (variable == this.uniquelyRealizedParameters) {
            this.likelihoodKnown = false;
            this.fireModelChanged();
        } else {
            throw new IllegalArgumentException("Unknown parameter");
        }
    }

    public void setVerbose() {
        VERBOSE = true;
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
        this.likelihoodKnown = false;
    }

    @Override
    protected void acceptState() {
    }

    public static void main(String[] stringArray) {
        DirichletProcessPrior.testDirichletProcess(new double[]{0.0, 1.0, 2.0}, 3, 1.0, -Math.log(6.0));
        DirichletProcessPrior.testDirichletProcess(new double[]{0.0, 0.0, 1.0}, 3, 1.0, -Math.log(6.0));
        DirichletProcessPrior.testDirichletProcess(new double[]{0.0, 1.0, 2.0, 3.0, 4.0}, 5, 0.5, -6.851184927493743);
    }

    private static void testDirichletProcess(double[] dArray, int n, double d, double d2) {
        Parameter.Default default_ = new Parameter.Default(dArray);
        Parameter.Default default_2 = new Parameter.Default(d);
        CompoundParameter compoundParameter = new CompoundParameter("dummy");
        for (int i = 0; i < n; ++i) {
            compoundParameter.addParameter(new Parameter.Default(1.0));
        }
        DirichletProcessPrior dirichletProcessPrior = new DirichletProcessPrior(default_, compoundParameter, null, default_2);
        dirichletProcessPrior.setVerbose();
        System.out.println("lnL:          " + dirichletProcessPrior.getCategoriesLogDensity());
        System.out.println("expected lnL: " + d2);
    }
}

