/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.treelikelihood;

import dr.evolution.alignment.PatternList;
import dr.evolution.datatype.DataType;
import dr.evolution.tree.NodeRef;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import dr.oldevomodel.treelikelihood.LikelihoodCore;
import dr.xml.Reportable;

@Deprecated
public abstract class AbstractTreeLikelihood
extends AbstractModelLikelihood
implements Reportable {
    protected static final boolean COUNT_TOTAL_OPERATIONS = true;
    protected TreeModel treeModel = null;
    protected PatternList patternList = null;
    protected DataType dataType = null;
    protected double[] patternWeights;
    protected int patternCount;
    protected int stateCount;
    protected int nodeCount;
    protected boolean[] updatePattern = null;
    protected boolean[] updateNode;
    private double logLikelihood;
    private double storedLogLikelihood;
    protected boolean likelihoodKnown = false;
    private boolean storedLikelihoodKnown = false;
    protected int totalOperationCount = 0;

    public AbstractTreeLikelihood(String string, PatternList patternList, TreeModel treeModel) {
        super(string);
        this.patternList = patternList;
        this.dataType = patternList.getDataType();
        this.patternCount = patternList.getPatternCount();
        this.stateCount = this.dataType.getStateCount();
        this.patternWeights = patternList.getPatternWeights();
        this.treeModel = treeModel;
        this.addModel(treeModel);
        this.nodeCount = treeModel.getNodeCount();
        this.updateNode = new boolean[this.nodeCount];
        for (int i = 0; i < this.nodeCount; ++i) {
            this.updateNode[i] = true;
        }
        this.likelihoodKnown = false;
    }

    protected final void setStates(LikelihoodCore likelihoodCore, PatternList patternList, int n, int n2) {
        int[] nArray = new int[this.patternCount];
        for (int i = 0; i < this.patternCount; ++i) {
            nArray[i] = patternList.getPatternState(n, i);
        }
        likelihoodCore.setNodeStates(n2, nArray);
    }

    public TreeModel getTreeModel() {
        return this.treeModel;
    }

    protected final void setPartials(LikelihoodCore likelihoodCore, PatternList patternList, int n, int n2, int n3) {
        double[] dArray = new double[this.patternCount * this.stateCount];
        int n4 = 0;
        for (int i = 0; i < this.patternCount; ++i) {
            int n5 = patternList.getPatternState(n2, i);
            boolean[] blArray = this.dataType.getStateSet(n5);
            for (int j = 0; j < this.stateCount; ++j) {
                dArray[n4] = blArray[j] ? 1.0 : 0.0;
                ++n4;
            }
        }
        likelihoodCore.setNodePartials(n3, dArray);
    }

    protected final void setMissingStates(LikelihoodCore likelihoodCore, int n) {
        int[] nArray = new int[this.patternCount];
        for (int i = 0; i < this.patternCount; ++i) {
            nArray[i] = this.dataType.getGapState();
        }
        likelihoodCore.setNodeStates(n, nArray);
    }

    protected final void setMissingPartials(LikelihoodCore likelihoodCore, int n) {
        double[] dArray = new double[this.patternCount * this.stateCount];
        int n2 = 0;
        for (int i = 0; i < this.patternCount; ++i) {
            for (int j = 0; j < this.stateCount; ++j) {
                dArray[n2] = 1.0;
                ++n2;
            }
        }
        likelihoodCore.setNodePartials(n, dArray);
    }

    protected void updateNode(NodeRef nodeRef) {
        this.updateNode[nodeRef.getNumber()] = true;
        this.likelihoodKnown = false;
    }

    protected void updateNodeAndChildren(NodeRef nodeRef) {
        this.updateNode[nodeRef.getNumber()] = true;
        for (int i = 0; i < this.treeModel.getChildCount(nodeRef); ++i) {
            NodeRef nodeRef2 = this.treeModel.getChild(nodeRef, i);
            this.updateNode[nodeRef2.getNumber()] = true;
        }
        this.likelihoodKnown = false;
    }

    protected void updateNodeAndDescendents(NodeRef nodeRef) {
        this.updateNode[nodeRef.getNumber()] = true;
        for (int i = 0; i < this.treeModel.getChildCount(nodeRef); ++i) {
            NodeRef nodeRef2 = this.treeModel.getChild(nodeRef, i);
            this.updateNodeAndDescendents(nodeRef2);
        }
        this.likelihoodKnown = false;
    }

    protected void updateAllNodes() {
        for (int i = 0; i < this.nodeCount; ++i) {
            this.updateNode[i] = true;
        }
        this.likelihoodKnown = false;
    }

    protected void updatePattern(int n) {
        if (this.updatePattern != null) {
            this.updatePattern[n] = true;
        }
        this.likelihoodKnown = false;
    }

    protected void updateAllPatterns() {
        if (this.updatePattern != null) {
            for (int i = 0; i < this.patternCount; ++i) {
                this.updatePattern[i] = true;
            }
        }
        this.likelihoodKnown = false;
    }

    public final double[] getPatternWeights() {
        return this.patternWeights;
    }

    public final int getPatternCount() {
        return this.patternCount;
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.likelihoodKnown = false;
    }

    @Override
    protected void storeState() {
        this.storedLikelihoodKnown = this.likelihoodKnown;
        this.storedLogLikelihood = this.logLikelihood;
    }

    @Override
    protected void restoreState() {
        this.likelihoodKnown = this.storedLikelihoodKnown;
        this.logLikelihood = this.storedLogLikelihood;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public final Model getModel() {
        return this;
    }

    public final PatternList getPatternList() {
        return this.patternList;
    }

    @Override
    public final double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.calculateLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    @Override
    public void makeDirty() {
        this.likelihoodKnown = false;
        this.updateAllNodes();
        this.updateAllPatterns();
    }

    protected abstract double calculateLogLikelihood();

    @Override
    public String getReport() {
        this.getLogLikelihood();
        return this.getClass().getName() + "(" + this.logLikelihood + ") total operations = " + this.totalOperationCount;
    }
}

