/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.sitemodel;

import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;

public class DiscretizedLociRates
extends AbstractModel {
    private CompoundParameter lociRates;
    private Parameter rateCategoryParameter;
    private ParametricDistributionModel distrModel;
    private double normalizeRateTo;
    private double[] rates;
    private boolean normalize;
    private int categoryCount;
    private double scaleFactor;
    private boolean completeSetup;

    public DiscretizedLociRates(CompoundParameter compoundParameter, Parameter parameter, ParametricDistributionModel parametricDistributionModel, boolean bl, double d, int n) {
        super("DiscretizedLociRatesModel");
        this.lociRates = compoundParameter;
        this.rateCategoryParameter = parameter;
        Parameter.DefaultBounds defaultBounds = new Parameter.DefaultBounds(n - 1, 0.0, parameter.getDimension());
        this.rateCategoryParameter.addBounds(defaultBounds);
        this.distrModel = parametricDistributionModel;
        this.normalizeRateTo = d;
        this.normalize = bl;
        this.categoryCount = n;
        this.rates = new double[n];
        this.completeSetup = true;
        this.setupRates();
        this.addModel(this.distrModel);
        this.addVariable(this.rateCategoryParameter);
    }

    private void setupRates() {
        if (this.completeSetup) {
            double d = 1.0 / (double)this.categoryCount;
            for (int i = 0; i < this.categoryCount; ++i) {
                this.rates[i] = this.distrModel.quantile(((double)i + 0.5) * d);
            }
        }
        if (this.normalize) {
            this.computeFactor();
        }
        this.completeSetup = false;
        int n = this.rateCategoryParameter.getDimension();
        for (int i = 0; i < n; ++i) {
            this.lociRates.setParameterValue(i, this.rates[(int)this.rateCategoryParameter.getParameterValue(i)] * this.scaleFactor);
        }
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.distrModel) {
            this.completeSetup = true;
            this.setupRates();
            this.fireModelChanged();
        } else if (model == this.rateCategoryParameter) {
            this.setupRates();
            this.fireModelChanged(null, n);
        }
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.setupRates();
        this.fireModelChanged(null, n);
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    protected void restoreState() {
    }

    private void computeFactor() {
        double d = 0.0;
        int n = this.rateCategoryParameter.getDimension();
        for (int i = 0; i < n; ++i) {
            d += this.rates[(int)this.rateCategoryParameter.getParameterValue(i)];
        }
        this.scaleFactor = this.normalizeRateTo / (d / (double)n);
    }
}

