/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.CompoundModel;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.LogTricks;
import dr.math.MathUtils;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.CommonCitations;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class MixtureModelLikelihood
extends AbstractModelLikelihood
implements Citable,
Loggable {
    public static final String MIXTURE_MODEL_ALIAS = "integratedMixtureModel";
    public static final String MIXTURE_MODEL = "mixtureModelLikelihood";
    public static final String NORMALIZE = "normalize";
    private static final boolean useParameter = true;
    private static final boolean powerPrior = false;
    public static XMLObjectParser PARSER_ALIAS = new AbstractXMLObjectParser(){

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            return ((AbstractXMLObjectParser)PARSER).parseXMLObject(xMLObject);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return PARSER.getSyntaxRules();
        }

        @Override
        public String getParserDescription() {
            return PARSER.getParserDescription();
        }

        @Override
        public Class getReturnType() {
            return PARSER.getReturnType();
        }

        @Override
        public String getParserName() {
            return MixtureModelLikelihood.MIXTURE_MODEL_ALIAS;
        }
    };
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newBooleanRule("normalize", true), new ElementRule(Likelihood.class, 2, Integer.MAX_VALUE), new ElementRule(Parameter.class)};

        @Override
        public String getParserName() {
            return MixtureModelLikelihood.MIXTURE_MODEL;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            ArrayList<Likelihood> arrayList = new ArrayList<Likelihood>();
            for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                if (!(xMLObject.getChild(i) instanceof Likelihood)) continue;
                arrayList.add((Likelihood)xMLObject.getChild(i));
            }
            if (parameter.getDimension() != arrayList.size()) {
                throw new XMLParseException("Dim of " + parameter.getId() + " does not match the number of likelihoods");
            }
            if (xMLObject.hasAttribute(MixtureModelLikelihood.NORMALIZE) && xMLObject.getBooleanAttribute(MixtureModelLikelihood.NORMALIZE)) {
                int n;
                double d = 0.0;
                for (n = 0; n < parameter.getDimension(); ++n) {
                    d += parameter.getParameterValue(n);
                }
                for (n = 0; n < parameter.getDimension(); ++n) {
                    parameter.setParameterValue(n, parameter.getParameterValue(n) / d);
                }
            }
            return new MixtureModelLikelihood(arrayList, parameter);
        }

        private boolean normalized(Parameter parameter) {
            double d = 0.0;
            for (int i = 0; i < parameter.getDimension(); ++i) {
                d += parameter.getParameterValue(i);
            }
            return d == 1.0;
        }

        @Override
        public String getParserDescription() {
            return "This element represents a finite mixture of likelihood models.";
        }

        @Override
        public Class getReturnType() {
            return CompoundModel.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private final Parameter mixtureWeights;
    List<Likelihood> likelihoodList;

    public MixtureModelLikelihood(List<Likelihood> list, Parameter parameter) {
        super(MIXTURE_MODEL);
        this.likelihoodList = list;
        this.mixtureWeights = parameter;
        for (Likelihood object : list) {
            if (object.getModel() == null) continue;
            this.addModel(object.getModel());
        }
        this.addVariable(this.mixtureWeights);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Constructing a finite mixture model\n");
        stringBuilder.append("\tComponents:\n");
        for (Likelihood likelihood : list) {
            Model model = likelihood.getModel();
            stringBuilder.append("\t\t\t").append(model != null ? likelihood.getModel().getId() : "anonymous").append("\n");
        }
        stringBuilder.append("\tPlease cite:\n");
        stringBuilder.append(Citable.Utils.getCitationString(this));
        Logger.getLogger("dr.inference.model").info(stringBuilder.toString());
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        return this.getLogLikelihoodSum();
    }

    private double getLogLikelihoodSum() {
        double d = Double.NEGATIVE_INFINITY;
        double d2 = 0.0;
        double[] dArray = MathUtils.getNormalized(this.mixtureWeights.getParameterValues());
        for (int i = 0; i < this.likelihoodList.size(); ++i) {
            double d3 = dArray[i];
            if (d3 > 0.0) {
                d = LogTricks.logSum(d, Math.log(d3) + this.likelihoodList.get(i).getLogLikelihood());
            }
            d2 += this.likelihoodList.get(i).getLogLikelihood() * d3;
        }
        return d;
    }

    private double getWeight(int n) {
        return this.mixtureWeights.getParameterValue(n);
    }

    @Override
    public void makeDirty() {
    }

    @Override
    public LogColumn[] getColumns() {
        LogColumn[] logColumnArray = new LogColumn[this.likelihoodList.size()];
        for (int i = 0; i < this.likelihoodList.size(); ++i) {
            logColumnArray[i] = new MixtureColumn(MIXTURE_MODEL, i);
        }
        return logColumnArray;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.MISC;
    }

    @Override
    public String getDescription() {
        return "Mixture model";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CommonCitations.LEMEY_MIXTURE_2012);
    }

    private class MixtureColumn
    extends NumberColumn {
        private final int dim;
        private final boolean inProbSpace = true;

        public MixtureColumn(String string, int n) {
            super(string);
            this.inProbSpace = true;
            this.dim = n;
        }

        @Override
        public double getDoubleValue() {
            double d = MixtureModelLikelihood.this.getLogLikelihoodSum();
            double d2 = MixtureModelLikelihood.this.likelihoodList.get(this.dim).getLogLikelihood() + Math.log(MixtureModelLikelihood.this.getWeight(this.dim));
            double d3 = d2 - d;
            d3 = Math.exp(d3);
            return d3;
        }
    }
}

