/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.util.Transform;

public class MarkovRandomFieldMatrix
extends MatrixParameter {
    private Parameter diagonalParameter;
    private Parameter offDiagonalParameter;
    private final Parameter nuggetParameter;
    private final Transform diagonalTransform;
    private final Transform offDiagonalTransform;
    private boolean asCorrelation = false;
    private int dim;

    public MarkovRandomFieldMatrix(String string, int n, Parameter parameter, Parameter parameter2, Parameter parameter3, boolean bl, Transform transform, Transform transform2) {
        super(string);
        this.diagonalParameter = parameter;
        this.offDiagonalParameter = parameter2;
        this.nuggetParameter = parameter3;
        this.addParameter(this.diagonalParameter);
        this.addParameter(this.offDiagonalParameter);
        this.addParameter(this.nuggetParameter);
        this.dim = n;
        this.asCorrelation = bl;
        this.diagonalTransform = transform != null ? transform : Transform.NONE;
        this.offDiagonalTransform = transform2 != null ? transform2 : Transform.NONE;
    }

    @Override
    public int getDimension() {
        return this.dim * this.dim;
    }

    @Override
    public String getDimensionName(int n) {
        int n2 = n / this.dim;
        int n3 = n % this.dim;
        return this.getParameterName() + "_" + (n2 + 1) + "_" + (n3 + 1);
    }

    private double getDiagonalParameterValue(int n) {
        return this.diagonalTransform.inverse(this.diagonalParameter.getParameterValue(n));
    }

    private double getOffDiagonalParameterValue(int n) {
        return this.offDiagonalTransform.inverse(this.offDiagonalParameter.getParameterValue(n));
    }

    private double getNuggetValue(int n) {
        return this.nuggetParameter.getParameterValue(n);
    }

    @Override
    public double getParameterValue(int n) {
        int n2 = n / this.dim;
        int n3 = n % this.dim;
        return this.getParameterValue(n2, n3);
    }

    @Override
    public double getParameterValue(int n, int n2) {
        if (n == n2) {
            double d = this.getDiagonalParameterValue(0);
            if (n > 0 && n < this.dim - 1) {
                d *= 2.0;
            }
            return d += this.getNuggetValue(0);
        }
        if (n == n2 - 1 || n == n2 + 1) {
            if (this.asCorrelation) {
                return -this.getOffDiagonalParameterValue(0) * Math.sqrt(this.getDiagonalParameterValue(0) * this.getDiagonalParameterValue(0));
            }
            return this.getOffDiagonalParameterValue(0);
        }
        return 0.0;
    }

    @Override
    public int getColumnDimension() {
        return this.dim;
    }

    @Override
    public int getRowDimension() {
        return this.dim;
    }
}

