/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.demographicmodel;

import dr.evolution.coalescent.CataclysmicDemographic;
import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.inference.model.Parameter;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Collections;
import java.util.List;

public class CataclysmicDemographicModel
extends DemographicModel
implements Citable {
    Parameter N0Parameter = null;
    Parameter N1Parameter = null;
    Parameter growthRateParameter = null;
    Parameter timeParameter = null;
    Parameter declineRateParameter = null;
    CataclysmicDemographic cataclysm = null;
    public static Citation CITATION = new Citation(new Author[]{new Author("B", "Shapiro"), new Author("", "et al.")}, "Rise and fall of the Beringian steppe bison", 2004, "Science", 306, 1561, 1565);

    public CataclysmicDemographicModel(Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Units.Type type, boolean bl) {
        this("cataclysm", parameter, parameter2, parameter3, parameter4, type, bl);
    }

    public CataclysmicDemographicModel(String string, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Units.Type type, boolean bl) {
        super(string);
        this.cataclysm = new CataclysmicDemographic(type);
        this.N0Parameter = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        if (bl) {
            this.N1Parameter = parameter2;
            this.N1Parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
            this.addVariable(this.N1Parameter);
        } else {
            this.declineRateParameter = parameter2;
            this.addVariable(this.declineRateParameter);
        }
        this.growthRateParameter = parameter3;
        this.addVariable(parameter3);
        parameter3.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.MIN_VALUE, 1));
        this.timeParameter = parameter4;
        this.addVariable(parameter4);
        parameter4.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.MIN_VALUE, 1));
        this.setUnits(type);
    }

    @Override
    public DemographicFunction getDemographicFunction() {
        this.cataclysm.setN0(this.N0Parameter.getParameterValue(0));
        this.cataclysm.setGrowthRate(this.growthRateParameter.getParameterValue(0));
        this.cataclysm.setCataclysmTime(this.timeParameter.getParameterValue(0) - this.getTimeOffset());
        double d = this.timeParameter.getParameterValue(0);
        double d2 = this.declineRateParameter == null ? Math.log(this.N1Parameter.getParameterValue(0)) / d : this.declineRateParameter.getParameterValue(0);
        this.cataclysm.setDeclineRate(d2);
        return this.cataclysm;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TREE_PRIORS;
    }

    @Override
    public String getDescription() {
        return "Boom-Bust Coalescent";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }
}

