/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic.phyloclustering.misc.obsolete;

import dr.evolution.tree.NodeRef;
import dr.evomodel.antigenic.phyloclustering.misc.obsolete.AGLikelihoodTreeCluster;
import dr.evomodel.antigenic.phyloclustering.misc.obsolete.TiterImporter;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.LinkedList;

public class TreeClusterGibbsOperator
extends SimpleMCMCOperator
implements GibbsOperator {
    Parameter virusOffsetsParameter;
    private double sigmaSq = 1.0;
    private int numdata = 0;
    private MatrixParameter mu = null;
    private Parameter clusterLabels = null;
    private Parameter K = null;
    private MatrixParameter virusLocations = null;
    private int maxLabel = 0;
    private int[] muLabels = null;
    private int[] groupSize;
    private double numAcceptMoveMu = 0.0;
    private double numProposeMoveMu = 0.0;
    private double numAcceptMoveC = 0.0;
    private double numProposeMoveC = 0.0;
    private int isMoveMu = -1;
    private double[] old_vLoc0;
    private double[] old_vLoc1;
    private Parameter clusterOffsetsParameter;
    private AGLikelihoodTreeCluster clusterLikelihood = null;
    private int groupSelectedChange = -1;
    private int virusIndexChange = -1;
    private double originalValueChange = -1.0;
    private int dimSelectChange = -1;
    private double[] mu0_offset;
    private Parameter indicators = null;
    private int binSize = 20;
    private Parameter excisionPoints;
    private TreeModel treeModel;
    public static final String TREE_CLUSTERGIBBS_OPERATOR = "TreeClusterGibbsOperator";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String VIRUSLOCATIONS = "virusLocations";
        public static final String MU = "mu";
        public static final String CLUSTERLABELS = "clusterLabels";
        public static final String K = "k";
        public static final String OFFSETS = "offsets";
        public static final String CLUSTER_OFFSETS = "clusterOffsetsParameter";
        public static final String INDICATORS = "indicators";
        public static final String EXCISION_POINTS = "excisionPoints";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), new ElementRule("virusLocations", Parameter.class), new ElementRule("mu", Parameter.class), new ElementRule("clusterLabels", Parameter.class), new ElementRule("k", Parameter.class), new ElementRule("offsets", Parameter.class), new ElementRule("clusterOffsetsParameter", Parameter.class, "Parameter of cluster offsets of all virus"), new ElementRule("indicators", Parameter.class), new ElementRule("excisionPoints", Parameter.class), new ElementRule(TreeModel.class)};

        @Override
        public String getParserName() {
            return TreeClusterGibbsOperator.TREE_CLUSTERGIBBS_OPERATOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("weight");
            XMLObject xMLObject2 = xMLObject.getChild(VIRUSLOCATIONS);
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject2.getChild(MatrixParameter.class);
            xMLObject2 = xMLObject.getChild(MU);
            MatrixParameter matrixParameter2 = (MatrixParameter)xMLObject2.getChild(MatrixParameter.class);
            xMLObject2 = xMLObject.getChild(CLUSTERLABELS);
            Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(K);
            Parameter parameter2 = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(OFFSETS);
            Parameter parameter3 = (Parameter)xMLObject2.getChild(Parameter.class);
            Parameter parameter4 = null;
            if (xMLObject.hasChildNamed(CLUSTER_OFFSETS)) {
                parameter4 = (Parameter)xMLObject.getElementFirstChild(CLUSTER_OFFSETS);
            }
            xMLObject2 = xMLObject.getChild(INDICATORS);
            Parameter parameter5 = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(EXCISION_POINTS);
            Parameter parameter6 = (Parameter)xMLObject2.getChild(Parameter.class);
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            AGLikelihoodTreeCluster aGLikelihoodTreeCluster = (AGLikelihoodTreeCluster)xMLObject.getChild(AGLikelihoodTreeCluster.class);
            return new TreeClusterGibbsOperator(matrixParameter, matrixParameter2, parameter, parameter2, d, parameter3, parameter4, parameter5, parameter6, treeModel, aGLikelihoodTreeCluster);
        }

        @Override
        public String getParserDescription() {
            return "An operator that picks a new allocation of an item to a cluster under the Dirichlet process.";
        }

        @Override
        public Class getReturnType() {
            return TreeClusterGibbsOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public TreeClusterGibbsOperator(MatrixParameter matrixParameter, MatrixParameter matrixParameter2, Parameter parameter, Parameter parameter2, double d, Parameter parameter3, Parameter parameter4, Parameter parameter5, Parameter parameter6, TreeModel treeModel, AGLikelihoodTreeCluster aGLikelihoodTreeCluster) {
        int n;
        int n2;
        System.out.println("Loading the constructor for ClusterGibbsOperator");
        this.clusterLikelihood = aGLikelihoodTreeCluster;
        this.treeModel = treeModel;
        this.mu = matrixParameter2;
        this.K = parameter2;
        this.clusterLabels = parameter;
        this.virusLocations = matrixParameter;
        this.virusOffsetsParameter = parameter3;
        this.clusterOffsetsParameter = parameter4;
        this.indicators = parameter5;
        this.excisionPoints = parameter6;
        this.numdata = parameter3.getSize();
        System.out.println("numdata=" + this.numdata);
        int n3 = (int)parameter2.getParameterValue(0);
        System.out.println("K_int=" + n3);
        this.groupSize = new int[this.binSize];
        for (n2 = 0; n2 < this.binSize; ++n2) {
            this.groupSize[n2] = 0;
        }
        for (n2 = 0; n2 < this.numdata; ++n2) {
            int n4 = n = (int)parameter.getParameterValue(n2);
            this.groupSize[n4] = this.groupSize[n4] + 1;
        }
        for (n2 = 0; n2 < this.numdata; ++n2) {
            if (this.maxLabel >= (int)parameter.getParameterValue(n2)) continue;
            this.maxLabel = (int)parameter.getParameterValue(n2);
        }
        this.muLabels = new int[this.binSize];
        for (n2 = 0; n2 < this.maxLabel; ++n2) {
            n = 0;
            if (this.groupSize[n2] <= 0) continue;
            this.muLabels[n] = n2;
            ++n;
        }
        this.setWeight(d);
        System.out.println("Finished loading the constructor for ClusterAlgorithmOperator");
    }

    @Override
    public final double doOperation() {
        int n;
        int n2;
        int n3 = this.treeModel.getNodeCount();
        double d = 0.0;
        double d2 = Math.random();
        int n4 = (int)this.K.getParameterValue(0);
        int n5 = -1;
        double[] dArray = new double[n3];
        int n6 = 0;
        int n7 = -1;
        while (n6 == 0) {
            int n8;
            boolean bl;
            int n9;
            n7 = (int)Math.floor(Math.random() * (double)this.binSize);
            n6 = (int)this.excisionPoints.getParameterValue(n7);
            if (n6 != 1) continue;
            n2 = (int)this.indicators.getParameterValue(n7);
            int[] nArray = new int[n3];
            for (n9 = 0; n9 < n3; ++n9) {
                nArray[n9] = 100000;
            }
            n = n9 = (int)this.indicators.getParameterValue(n7);
            NodeRef nodeRef = this.treeModel.getNode(n9);
            LinkedList<NodeRef> linkedList = new LinkedList<NodeRef>();
            LinkedList<NodeRef> linkedList2 = new LinkedList<NodeRef>();
            LinkedList<Integer> linkedList3 = new LinkedList<Integer>();
            LinkedList<Integer> linkedList4 = new LinkedList<Integer>();
            Object e = null;
            linkedList.add(nodeRef);
            linkedList2.add((NodeRef)e);
            linkedList3.add(new Integer(0));
            int n10 = 1000;
            while (linkedList.size() > 0) {
                int n11;
                if (this.treeModel.getParent(nodeRef) != null) {
                    NodeRef nodeRef2 = this.treeModel.getParent(nodeRef);
                    if (linkedList2.getFirst() != nodeRef2 && (Integer)linkedList3.getFirst() < n10) {
                        linkedList.add(nodeRef2);
                        linkedList2.add(nodeRef);
                        linkedList3.add(new Integer((Integer)linkedList3.getFirst() + 1));
                    }
                }
                for (n11 = 0; n11 < this.treeModel.getChildCount(nodeRef); ++n11) {
                    NodeRef nodeRef3 = this.treeModel.getChild(nodeRef, n11);
                    if (linkedList2.getFirst() == nodeRef3 || (Integer)linkedList3.getFirst() >= n10) continue;
                    linkedList.add(nodeRef3);
                    linkedList2.add(nodeRef);
                    linkedList3.add(new Integer((Integer)linkedList3.getFirst() + 1));
                }
                n11 = nodeRef.getNumber();
                bl = false;
                for (int i = 0; i < this.binSize; ++i) {
                    if (this.indicators.getParameterValue(i) != (double)n11) continue;
                    bl = true;
                    break;
                }
                if (!bl || nodeRef.getNumber() == n) {
                    nArray[n11] = (Integer)linkedList3.getFirst();
                    linkedList4.addLast(new Integer(n11));
                }
                linkedList.pop();
                linkedList2.pop();
                linkedList3.pop();
                if (linkedList.size() <= 0) continue;
                nodeRef = (NodeRef)linkedList.getFirst();
            }
            for (int i = 0; i < n3; ++i) {
                int n12;
                int n13;
                bl = false;
                for (n13 = 0; n13 < this.binSize; ++n13) {
                    if (this.indicators.getParameterValue(n13) != (double)i) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    double d3;
                    dArray[i] = d3 = Double.NEGATIVE_INFINITY;
                    continue;
                }
                n13 = i;
                this.indicators.setParameterValue(n7, n13);
                int n14 = 0;
                for (int j = 0; j < this.binSize; ++j) {
                    n14 += (int)this.excisionPoints.getParameterValue(j);
                }
                this.K.setParameterValue(0, n14);
                n4 = n14;
                this.setClusterLabels(n4);
                double[] dArray2 = new double[this.binSize];
                double[] dArray3 = new double[this.binSize];
                for (n12 = 0; n12 < this.numdata; ++n12) {
                    n8 = (int)this.clusterLabels.getParameterValue(n12);
                    double d4 = 0.0;
                    if (this.virusOffsetsParameter != null) {
                        d4 = this.virusOffsetsParameter.getParameterValue(n12);
                    } else {
                        System.out.println("virus Offeset Parameter NOT present. We expect one though. Something is wrong.");
                    }
                    dArray2[n8] = dArray2[n8] + d4;
                    dArray3[n8] = dArray3[n8] + 1.0;
                }
                for (n12 = 0; n12 < this.binSize; ++n12) {
                    if (!(dArray3[n12] > 0.0)) continue;
                    dArray2[n12] = dArray2[n12] / dArray3[n12];
                }
                this.mu0_offset = new double[this.binSize];
                for (n12 = 0; n12 < this.binSize; ++n12) {
                    this.mu0_offset[n12] = dArray2[n12];
                }
                for (n12 = 0; n12 < this.numdata; ++n12) {
                    n8 = (int)this.clusterLabels.getParameterValue(n12);
                    Parameter parameter = this.virusLocations.getParameter(n12);
                    double d5 = this.mu.getParameter(n8).getParameterValue(0);
                    parameter.setParameterValue(0, d5);
                    double d6 = this.mu.getParameter(n8).getParameterValue(1);
                    parameter.setParameterValue(1, d6);
                }
                for (n12 = 0; n12 < this.numdata; ++n12) {
                    n8 = (int)this.clusterLabels.getParameterValue(n12);
                    if (this.clusterOffsetsParameter == null) continue;
                    this.clusterOffsetsParameter.setParameterValue(n12, this.mu0_offset[n8]);
                }
                dArray[i] = this.clusterLikelihood.getLogLikelihood();
            }
            n5 = n7;
            double d7 = dArray[0];
            for (int i = 0; i < n3; ++i) {
                if (!(dArray[i] > d7)) continue;
                d7 = dArray[i];
            }
            double d8 = 0.0;
            for (int i = 0; i < n3; ++i) {
                if (dArray[i] == Double.NEGATIVE_INFINITY) continue;
                d8 += Math.exp(dArray[i] - d7);
            }
            d8 = Math.log(d8) + d7;
            double d9 = 0.0;
            double[] dArray4 = new double[n3];
            for (n8 = 0; n8 < n3; ++n8) {
                dArray4[n8] = Math.exp(dArray[n8] - d8);
                d9 += dArray4[n8];
                if (!(dArray4[n8] > 0.01)) continue;
            }
            n8 = MathUtils.randomChoicePDF(dArray4);
            if (nArray[n8] > 0) {
                System.out.println("Gibbs move: indicator " + n7 + " from site " + n2 + " to " + n8 + " , chosen with prob =" + dArray4[n8] + " steps from previous placement=" + nArray[n8]);
            }
            this.indicators.setParameterValue(n7, n8);
        }
        n2 = 0;
        for (int i = 0; i < this.binSize; ++i) {
            n2 += (int)this.excisionPoints.getParameterValue(i);
        }
        this.K.setParameterValue(0, n2);
        n4 = n2;
        this.setClusterLabels(n4);
        double[] dArray5 = new double[this.binSize];
        double[] dArray6 = new double[this.binSize];
        for (n = 0; n < this.numdata; ++n) {
            int n15 = (int)this.clusterLabels.getParameterValue(n);
            double d10 = 0.0;
            if (this.virusOffsetsParameter != null) {
                d10 = this.virusOffsetsParameter.getParameterValue(n);
            } else {
                System.out.println("virus Offeset Parameter NOT present. We expect one though. Something is wrong.");
            }
            dArray5[n15] = dArray5[n15] + d10;
            dArray6[n15] = dArray6[n15] + 1.0;
        }
        for (n = 0; n < this.binSize; ++n) {
            if (!(dArray6[n] > 0.0)) continue;
            dArray5[n] = dArray5[n] / dArray6[n];
        }
        this.mu0_offset = new double[this.binSize];
        for (n = 0; n < this.binSize; ++n) {
            this.mu0_offset[n] = dArray5[n];
        }
        for (n = 0; n < this.numdata; ++n) {
            int n16 = (int)this.clusterLabels.getParameterValue(n);
            Parameter parameter = this.virusLocations.getParameter(n);
            double d11 = this.mu.getParameter(n16).getParameterValue(0);
            parameter.setParameterValue(0, d11);
            double d12 = this.mu.getParameter(n16).getParameterValue(1);
            parameter.setParameterValue(1, d12);
        }
        for (n = 0; n < this.numdata; ++n) {
            int n17 = (int)this.clusterLabels.getParameterValue(n);
            if (this.clusterOffsetsParameter == null) continue;
            this.clusterOffsetsParameter.setParameterValue(n, this.mu0_offset[n17]);
        }
        return d;
    }

    private void setClusterLabels(int n) {
        Parameter parameter;
        int n2;
        int n3 = this.treeModel.getNodeCount();
        int[] nArray = new int[n];
        int n4 = 0;
        String string = "";
        for (int i = 0; i < this.binSize; ++i) {
            if ((int)this.excisionPoints.getParameterValue(i) != 1) continue;
            nArray[n4] = (int)this.indicators.getParameterValue(i);
            string = string + (int)this.indicators.getParameterValue(i) + ",";
            ++n4;
        }
        if (n4 != n) {
            System.out.println("cutNum != K_int. we got a problem");
        }
        int[] nArray2 = TreeClusterGibbsOperator.determine_membership(this.treeModel, nArray, n);
        double d = 0.0;
        for (int i = 0; i < n3; ++i) {
            d += (double)(nArray2[i] * i);
        }
        int[] nArray3 = new int[this.numdata];
        for (n2 = 0; n2 < this.numdata; ++n2) {
            parameter = this.virusLocations.getParameter(n2);
            String string2 = parameter.getParameterName();
            boolean bl = false;
            for (int i = 0; i < n3; ++i) {
                String string3 = this.treeModel.getTaxonId(i);
                if (!string2.equals(string3)) continue;
                nArray3[n2] = i;
                bl = true;
                break;
            }
            if (bl) continue;
            System.out.println("not found. Exit now.");
            System.exit(0);
        }
        for (n2 = 0; n2 < this.numdata; ++n2) {
            parameter = this.virusLocations.getParameter(n2);
            this.clusterLabels.setParameterValue(n2, nArray2[nArray3[n2]]);
        }
    }

    private static boolean isCutNode(int n, int[] nArray, int n2) {
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                if (n != nArray[i]) continue;
                return true;
            }
        }
        return false;
    }

    static int[] determine_membership(TreeModel treeModel, int[] nArray, int n) {
        TiterImporter titerImporter = null;
        try {
            FileReader fileReader = new FileReader("/Users/charles/Documents/research/antigenic/GenoPheno/data/taxon_y_titer.txt");
            titerImporter = new TiterImporter(fileReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        NodeRef nodeRef = treeModel.getRoot();
        int n2 = 1;
        LinkedList<NodeRef> linkedList = new LinkedList<NodeRef>();
        linkedList.addFirst(nodeRef);
        int[] nArray2 = new int[treeModel.getNodeCount()];
        for (int i = 0; i < treeModel.getNodeCount(); ++i) {
            nArray2[i] = -1;
        }
        nArray2[nodeRef.getNumber()] = 0;
        while (!linkedList.isEmpty()) {
            NodeRef nodeRef2 = (NodeRef)linkedList.pop();
            String string = "node #" + nodeRef2.getNumber() + ", taxon= ";
            string = treeModel.getNodeTaxon(nodeRef2) == null ? string + "internal node\t" : string + treeModel.getNodeTaxon(nodeRef2).getId() + "\t";
            if (treeModel.getParent(nodeRef2) == null) {
                // empty if block
            }
            if (!treeModel.isRoot(nodeRef2)) {
                nArray2[nodeRef2.getNumber()] = TreeClusterGibbsOperator.isCutNode(nodeRef2.getNumber(), nArray, n) ? ++n2 - 1 : nArray2[treeModel.getParent(nodeRef2).getNumber()];
            }
            string = string + " cluster = " + nArray2[nodeRef2.getNumber()];
            for (int i = 0; i < treeModel.getChildCount(nodeRef2); ++i) {
                linkedList.addFirst(treeModel.getChild(nodeRef2, i));
            }
        }
        return nArray2;
    }

    @Override
    public void accept(double d) {
        super.accept(d);
    }

    @Override
    public void reject() {
        super.reject();
        System.out.println("        \t*      Rejected!");
    }

    @Override
    public final String getOperatorName() {
        return TREE_CLUSTERGIBBS_OPERATOR;
    }

    public final void optimize(double d) {
        throw new RuntimeException("This operator cannot be optimized!");
    }

    public boolean isOptimizing() {
        return false;
    }

    public void setOptimizing(boolean bl) {
        throw new RuntimeException("This operator cannot be optimized!");
    }

    public double getMinimumAcceptanceLevel() {
        return 0.1;
    }

    public double getMaximumAcceptanceLevel() {
        return 0.4;
    }

    public double getMinimumGoodAcceptanceLevel() {
        return 0.2;
    }

    public double getMaximumGoodAcceptanceLevel() {
        return 0.3;
    }

    public String getPerformanceSuggestion() {
        if (this.getAcceptanceProbability() < this.getMinimumAcceptanceLevel()) {
            return "";
        }
        if (this.getAcceptanceProbability() > this.getMaximumAcceptanceLevel()) {
            return "";
        }
        return "";
    }

    public int getStepCount() {
        return 1;
    }
}

