/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.phylogeny;

import dr.evolution.phylogeny.Lineage;

public abstract class Phylogeny {
    public static final int INCREMENT = 10000;
    Lineage[] lineages = new Lineage[10000];
    int lineageCount = 0;
    int availableSize = 0;
    int[] extantLineages;

    Phylogeny() {
    }

    public void lineageBirth(Lineage lineage, double d) {
        int n = this.createLineage(lineage, d);
        int n2 = this.createLineage(lineage, d);
        int n3 = this.extantLineages[lineage.getExtantIndex()];
        this.extantLineages[lineage.getExtantIndex()] = n;
    }

    public void lineageDeath(Lineage lineage, double d) {
        lineage.setDeathTime(d);
    }

    private int createLineage(Lineage lineage, double d) {
        int n = this.lineageCount;
        if (this.availableSize > 0) {
            --this.availableSize;
        } else {
            if (this.lineageCount == this.lineages.length) {
                Lineage[] lineageArray = new Lineage[this.lineages.length + 10000];
                for (int i = 0; i < this.lineages.length; ++i) {
                    lineageArray[i] = this.lineages[i];
                }
                this.lineages = lineageArray;
            }
            this.lineages[n] = this.newLineage(lineage, d);
            this.lineages[n].setIndex(n);
        }
        ++this.lineageCount;
        return n;
    }

    protected abstract Lineage newLineage(Lineage var1, double var2);
}

