/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent;

import dr.evolution.coalescent.LogisticGrowth;
import dr.evolution.util.Units;

public class ConstLogistic
extends LogisticGrowth {
    private double N1 = 0.0;

    public ConstLogistic(Units.Type type) {
        super(type);
    }

    public double getN1() {
        return this.N1;
    }

    public void setN1(double d) {
        this.N1 = d;
    }

    @Override
    public double getDemographic(double d) {
        double d2 = this.getN0();
        double d3 = this.getN1();
        double d4 = this.getGrowthRate();
        double d5 = this.getShape();
        double d6 = Math.exp(-d4 * d);
        return d3 + (d2 - d3) * (1.0 + d5) * d6 / (d5 + d6);
    }

    @Override
    public double getIntensity(double d) {
        double d2 = this.getN0();
        double d3 = this.getN1();
        double d4 = this.getGrowthRate();
        double d5 = this.getShape();
        double d6 = d3 + (d2 - d3) * (1.0 + d5);
        double d7 = d3 * d5;
        double d8 = Math.exp(-d4 * d);
        double d9 = Math.log(d7 + d6 * d8) / (d6 * -d4);
        double d10 = d5 * Math.log(d6 + d7 / d8) / (d7 * d4);
        return d9 + d10;
    }

    @Override
    public double getInverseIntensity(double d) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public double getIntegral(double d, double d2) {
        double d3 = this.getIntensity(d2) - this.getIntensity(d);
        double d4 = this.getNumericalIntegral(d, d2);
        return d4;
    }

    @Override
    public int getNumArguments() {
        return 4;
    }

    @Override
    public String getArgumentName(int n) {
        switch (n) {
            case 0: {
                return "N0";
            }
            case 1: {
                return "r";
            }
            case 2: {
                return "c";
            }
            case 3: {
                return "N1";
            }
        }
        throw new IllegalArgumentException("Argument " + n + " does not exist");
    }

    @Override
    public double getArgument(int n) {
        switch (n) {
            case 0: {
                return this.getN0();
            }
            case 1: {
                return this.getGrowthRate();
            }
            case 2: {
                return this.getShape();
            }
            case 3: {
                return this.getN1();
            }
        }
        throw new IllegalArgumentException("Argument " + n + " does not exist");
    }

    @Override
    public void setArgument(int n, double d) {
        switch (n) {
            case 0: {
                this.setN0(d);
                break;
            }
            case 1: {
                this.setGrowthRate(d);
                break;
            }
            case 2: {
                this.setShape(d);
                break;
            }
            case 3: {
                this.setN1(d);
                break;
            }
            default: {
                throw new IllegalArgumentException("Argument " + n + " does not exist");
            }
        }
    }

    @Override
    public double getLowerBound(int n) {
        return 0.0;
    }

    @Override
    public double getUpperBound(int n) {
        return Double.POSITIVE_INFINITY;
    }
}

