/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.Bounds;
import dr.inference.model.Parameter;

public interface Scalable {
    public int scale(double var1, int var3, boolean var4);

    public boolean testBounds();

    public String getName();

    public static class Default
    implements Scalable {
        private final Parameter parameter;

        public Default(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public int scale(double d, int n, boolean bl) {
            assert (n <= 0);
            int n2 = this.parameter.getDimension();
            for (int i = 0; i < n2; ++i) {
                this.parameter.setParameterValue(i, this.parameter.getParameterValue(i) * d);
            }
            if (bl) {
                Bounds<Double> bounds = this.parameter.getBounds();
                for (int i = 0; i < n2; ++i) {
                    double d2 = this.parameter.getParameterValue(i);
                    if (!(d2 < bounds.getLowerLimit(i)) && !(d2 > bounds.getUpperLimit(i))) continue;
                    throw new RuntimeException("proposed value outside bounds");
                }
            }
            return n2;
        }

        @Override
        public boolean testBounds() {
            int n = this.parameter.getDimension();
            Bounds<Double> bounds = this.parameter.getBounds();
            for (int i = 0; i < n; ++i) {
                double d = this.parameter.getParameterValue(i);
                if (!(d < bounds.getLowerLimit(i)) && !(d > bounds.getUpperLimit(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public String getName() {
            return this.parameter.getParameterName();
        }

        public int scaleAllAndNotify(double d, int n, boolean bl) {
            assert (n <= 0);
            int n2 = this.parameter.getDimension();
            int n3 = n2 - 1;
            for (int i = 0; i < n3; ++i) {
                this.parameter.setParameterValueQuietly(i, this.parameter.getParameterValue(i) * d);
            }
            this.parameter.setParameterValueNotifyChangedAll(n3, this.parameter.getParameterValue(n3) * d);
            if (bl) {
                Bounds<Double> bounds = this.parameter.getBounds();
                for (int i = 0; i < n2; ++i) {
                    double d2 = this.parameter.getParameterValue(i);
                    if (!(d2 < bounds.getLowerLimit(i)) && !(d2 > bounds.getUpperLimit(i))) continue;
                    throw new RuntimeException("proposed value outside bounds");
                }
            }
            return n2;
        }
    }
}

