/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evolution.tree.Tree;
import dr.evomodel.continuous.MultivariateDiffusionModel;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class BiasedMultivariateDiffusionModel
extends MultivariateDiffusionModel {
    public static final String BIASED_DIFFUSION_PROCESS = "biasedMultivariateDiffusionModel";
    public static final String BIAS_PARAMETER = "biasParameter";
    public static final String BIAS_TREE_ATTRIBUTE = "bias";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("precisionMatrix", new XMLSyntaxRule[]{new ElementRule(MatrixParameter.class)}), new ElementRule("biasParameter", new XMLSyntaxRule[]{new ElementRule(Parameter.class)})};

        @Override
        public String getParserName() {
            return BiasedMultivariateDiffusionModel.BIASED_DIFFUSION_PROCESS;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            XMLObject xMLObject2 = xMLObject.getChild(BiasedMultivariateDiffusionModel.BIAS_PARAMETER);
            Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild("precisionMatrix");
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject2.getChild(MatrixParameter.class);
            return new BiasedMultivariateDiffusionModel(parameter, matrixParameter);
        }

        @Override
        public String getParserDescription() {
            return "Describes a multivariate normal diffusion process.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return MultivariateDiffusionModel.class;
        }
    };
    private Parameter biasParam;

    BiasedMultivariateDiffusionModel(Parameter parameter, MatrixParameter matrixParameter) {
        super(matrixParameter);
        this.biasParam = parameter;
        this.addVariable(parameter);
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.diffusionPrecisionMatrixParameter) {
            this.calculatePrecisionInfo();
        }
    }

    @Override
    protected double calculateLogDensity(double[] dArray, double[] dArray2, double d) {
        int n = dArray2.length;
        double[] dArray3 = this.biasParam.getParameterValues();
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            dArray3[n2] = dArray3[n2] * d;
            int n3 = i;
            dArray3[n3] = dArray3[n3] + dArray[i];
        }
        return super.calculateLogDensity(dArray3, dArray2, d);
    }

    @Override
    public String[] getTreeAttributeLabel() {
        return new String[]{"precision", BIAS_TREE_ATTRIBUTE};
    }

    @Override
    public String[] getAttributeForTree(Tree tree) {
        return new String[]{this.diffusionPrecisionMatrixParameter.toSymmetricString(), this.toParameterString(this.biasParam)};
    }

    private String toParameterString(Parameter parameter) {
        StringBuffer stringBuffer = new StringBuffer("{");
        int n = parameter.getDimension();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(String.format("%5.4e", parameter.getParameterValue(i)));
            if (i >= n - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

