% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize}
\alias{normalize}
\title{Normalize Response and Covariates}
\usage{
normalize(y, X, scale = TRUE)
}
\arguments{
\item{y}{A numeric response vector.}

\item{X}{A numeric matrix or data frame of covariates (design matrix).}

\item{scale}{Logical; if \code{TRUE}, variables are scaled to have unit population variance (default is \code{TRUE}).}
}
\value{
A list with the following elements:
\itemize{
  \item \code{vy}: Normalized response vector.
  \item \code{mX}: Normalized design matrix.
  \item \code{mu.y}: Mean of the response vector.
  \item \code{sigma2.y}: Population variance of the response vector.
  \item \code{mu.x}: Vector of column means of \code{X}.
  \item \code{sigma2.x}: Vector of population variances for columns of \code{X}.
}
}
\description{
This function centers and (optionally) scales the response vector and each column
of the design matrix using the population variance. It is used to prepare data
for Bayesian Lasso regression.
}
\examples{
set.seed(1)
X <- matrix(rnorm(100 * 10), 100, 10)
beta <- c(2, -3, rep(0, 8))
y <- as.vector(X \%*\% beta + rnorm(100))
norm_result <- normalize(y, X)

}
