% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation_error_srsc.R
\name{error_srsc_error_visualization}
\alias{error_srsc_error_visualization}
\title{Visualization Of Error Analysis}
\usage{
error_srsc_error_visualization(return.value.of_error_srsc,
  log_scale_x.axis = TRUE)
}
\arguments{
\item{return.value.of_error_srsc}{A return value
of the function \code{\link{error_srsc}()}.}

\item{log_scale_x.axis}{A logical,
whether x axis is log scale or not.}
}
\value{
A long format dataframe of
 error and its parameter name
}
\description{
Visualization Of Error Analysis
}
\examples{

# General plot

df <- data.frame(x=runif(100),y=runif(100),g= as.factor(rep(1:5,10)))

ggplot(df, aes(x = x, y = y, shape = g)) +
  geom_point(size = 3) +
  scale_shape_manual(values = c(1,2,3,4,5,6,7,8,9))









df <- data.frame(x=runif(100),y=runif(100),g= as.factor(rep(1:25,4)))

  # Use slightly larger points and use custom values for the shape scale
ggplot(df, aes(x = x, y = y, shape = g)) +
  geom_point(size = 3) +
  scale_shape_manual(values = c(1,2,3,4,5,6,7,8,9,10,
                                11,12,13,14,15,16,17,18,19,20,21,22,23,24,25))

\donttest{
 a <- error_srsc()

 error_srsc_error_visualization(a)


#----------------------------------------------------------------------------------------
#              In case of C = 4, arbitrary C is available.
#----------------------------------------------------------------------------------------

  a <-error_srsc(NLvector = c(
100,
10000,
1000000,
10000000
),
ratio=2,
replicate.datset =2,
ModifiedPoisson = FALSE,
mean.truth=0.6,
sd.truth=5.3,
z.truth =c(-0.8,0.7,2.38,3), # Here we use the C=4
ite =500
)

error_srsc_error_visualization(a)
error_srsc_variance_visualization(a)











#----------------------------------------------------------------------------------------
#              In case of C = 7, arbitrary C is available.
#----------------------------------------------------------------------------------------







#'
a <-error_srsc(NLvector = c(
  100,
  10000,
  1000000,
  10000000
),
ratio=2,
replicate.datset =2,
ModifiedPoisson = FALSE,
mean.truth=0.6,
sd.truth=5.3,
z.truth =c(-0.8,0.7,2.38,3,3.4,3.6,3.8), # Here we use the C=7
ite =500
)

error_srsc_error_visualization(a)
error_srsc_variance_visualization(a)













}

}
\seealso{
\link{error_srsc_variance_visualization}
}
