% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation_Based_Calibration.R
\name{Draw_a_simulated_data_set_and_Draw_posterior_samples}
\alias{Draw_a_simulated_data_set_and_Draw_posterior_samples}
\title{Draw a dataset and MCMC samples}
\usage{
Draw_a_simulated_data_set_and_Draw_posterior_samples(sd = 5, C = 5,
  seed.for.drawing.a.prior.sample = 1111, fun = stats::var, NI = 259,
  NL = 259, initial.seed.for.drawing.a.data = 1234,
  ModifiedPoisson = FALSE, PreciseLogLikelihood = TRUE, ite = 1111,
  DrawCurve = FALSE)
}
\arguments{
\item{sd}{Standard Deviation of priors}

\item{C}{No. of Confidence levels}

\item{seed.for.drawing.a.prior.sample}{seed}

\item{fun}{An one dimensional real valued function defined on the parameter space. This is used in the definition of the rank statistics. Generally speaking, the element of the parameter space is a vector, so the function should be defined on vectors. In my model parameter is mean, standard deviation, C thresholds of the latent Gaussian, so this function should be defined on the C+2 dimensional Euclidean space.}

\item{NI}{No. of images}

\item{NL}{No. of Lesions}

\item{initial.seed.for.drawing.a.data}{seed}

\item{ModifiedPoisson}{Logical, that is \code{TRUE} or \code{FALSE}. If
\code{ModifiedPoisson = TRUE}, then Poisson rate of false alarm are \code{per lesion},
and if \code{ModifiedPoisson = FALSE}, then Poisson rate of false alarm are \code{per image}.
To know detail, refer the author's paper in which I explained per image and per lesion.}

\item{PreciseLogLikelihood}{Logical, that is \code{TRUE} or \code{FALSE}. If \code{PreciseLogLikelihood  = TRUE}(default), then Stan calculates the precise log likelihood with target formulation.

If \code{PreciseLogLikelihood  = FALSE}, then Stan calculates the log likelihood by dropping the constant terms in the likelihood function.
In past, I distinct the stan file, one is target formulation and the another is not. But non-target formulation cause some Jacobian warnning, thus I made all stanfile with target formulation when I uploaded to CRAN. Thus this variable is now meaningless.}

\item{ite}{An argument of \code{rstan::}\code{\link[rstan]{sampling}}()  in which it is named \code{iter}. A positive integer representing  the  number of samples generated by Hamiltonian Monte Carlo method,
and, default = 10000. If your model could not converge, then raise this number. Must be greater for more reliable estimates.}

\item{DrawCurve}{Logical: \code{TRUE} of \code{FALSE}. Whether the curve is to be drawn. TRUE or FALSE. If you want to draw the FROC and AFROC curves, then you set \code{DrawCurve =TRUE}, if not then \code{DrawCurve =FALSE}.
The reason why the author make this variable \code{DrawCurve} is that it takes long time in MRMC case to draw curves, and thus default value is \code{FALSE}.}
}
\value{
Draw.a.prior.sample The Return value of \code{Draw_a_prior_sample}

A dataList and an object of the stanfit S4 class with respect to the dataList
}
\description{
Draw a dataset and MCMC samples
}
\examples{
\donttest{

#  Draw a curve for various seeds and various number of confidence levels.
#  Changing the seed, we can draw a parameter from priors and using this sample,
#  we can draw the datasets from our model whose parameters are
#  the priors samples.


#     1. draw a prior sample,
#     2. draw a data from the model at the prior sample drawn in step 1,
#     3. draw a posterior sample for the data drawn in step 2.



 Draw_a_simulated_data_set_and_Draw_posterior_samples(
 seed.for.drawing.a.prior.sample = 1234,
 C=8)

   Draw_a_simulated_data_set_and_Draw_posterior_samples(
 seed.for.drawing.a.prior.sample = 12345,
 C=7)

    Draw_a_simulated_data_set_and_Draw_posterior_samples(
 seed.for.drawing.a.prior.sample = 123456,
 C=6)


    Draw_a_simulated_data_set_and_Draw_posterior_samples(
 seed.for.drawing.a.prior.sample = 1234567,
 C=5)


}# dottest

}
\seealso{
hits_false_alarms_creator_from_thresholds
}
