% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialSPsurv.R
\name{spatialSPsurv}
\alias{spatialSPsurv}
\alias{summary.spatialSPsurv}
\alias{print.spatialSPsurv}
\alias{plot.spatialSPsurv}
\title{spatialSPsurv}
\usage{
spatialSPsurv(
  duration,
  immune,
  Y0,
  LY,
  S,
  A,
  data,
  N,
  burn,
  thin,
  w = c(1, 1, 1),
  m = 10,
  ini.beta = 0,
  ini.gamma = 0,
  ini.W = 0,
  ini.V = 0,
  form = c("Weibull", "exponential", "loglog"),
  prop.varV,
  prop.varW,
  id_WV = colnames(A)
)

\method{summary}{spatialSPsurv}(object, parameter = character(), ...)

\method{print}{spatialSPsurv}(x, ...)

\method{plot}{spatialSPsurv}(x, parameter = character(), ...)
}
\arguments{
\item{duration}{survival stage equation written in a formula of the form Y ~ X1 + X2 + ... where Y is duration until failure or censoring.}

\item{immune}{split stage equation written in a formula of the form C ~ Z1 + Z2 + ... where C is a binary indicator of immunity.}

\item{Y0}{the elapsed time since inception until the beginning of time period (t-1).}

\item{LY}{last observation year (coded as 1; 0 otherwise) due to censoring or failure.}

\item{S}{spatial information (e.g. district ID) for each observation that matches the spatial matrix row/column information.}

\item{A}{an a times a spatial weights matrix where a is the number of unique spatial units (S) load as a separate file.}

\item{data}{data.frame.}

\item{N}{number of MCMC iterations.}

\item{burn}{burn-in to be discarded.}

\item{thin}{thinning to prevent from autocorrelation.}

\item{w}{size of the slice in the slice sampling for (betas, gammas, rho). Write it as a vector. E.g. c(1,1,1).}

\item{m}{limit on steps in the slice sampling. A vector of values for beta, gamma, rho.}

\item{ini.beta}{initial value for the parameter vector beta.  By default is 0.}

\item{ini.gamma}{initial value for the parameter vector gamma. By default is 0.}

\item{ini.W}{initial value for the parameter vector W. By default is 0.}

\item{ini.V}{initial value for the parameter vector V.  By default is 0.}

\item{form}{type of parametric model (Weibull, Exponential, or Log-Logistic).}

\item{prop.varV}{proposal for variance of V in Metropolis-Hastings.}

\item{prop.varW}{proposal for variance of W in Metropolis-Hastings.}

\item{id_WV}{vector of type character that modifies the colnames of W and V in the model’s result. By default is \code{colnames(A)}.}

\item{object}{an object of class \code{spatialSPsurv}, the output of \code{\link{spatialSPsurv}}.}

\item{parameter}{one of five parameters of the \code{\link{spatialSPsurv}} output. Indicate either "betas," "gammas," "rho", "lambda" or "delta".}

\item{...}{additional parameter.}

\item{x}{an object of class \code{spatialSPsurv}, the output of \code{\link{spatialSPsurv}}.}
}
\value{
spatialSPsurv returns an object of class \code{"spatialSPsurv"}.

A \code{"spatialSPsurv"} object has the following elements:
\item{betas}{matrix, numeric values of the posterior for each variable in the duration equation .}
\item{gammas}{matrix, numeric values of the posterior for each variable in the immune equation.}
\item{rho}{vector, numeric values of rho.}
\item{lambda}{vector, numeric values of lambda.}
\item{delta}{vector, numeric values of delta.}
\item{W}{matrix, numeric values of the posterior for Ws.}
\item{V}{matrix, numeric values of the posterior for Vs. }
\item{X}{matrix of X's variables.}
\item{Z}{matrix of Z's variables.}
\item{Y}{vector of `Y'.}
\item{Y0}{vector of `Y0'.}
\item{C}{vector of `C'.}
\item{S}{vector of `S'.}
\item{ini.beta}{numeric initial values of beta.}
\item{ini.gamma}{numeric initial values of gamma.}
\item{ini.W}{numeric initial values of W.}
\item{ini.V}{numeric initial values of V.}
\item{form}{character, type of distribution.}
\item{call}{description for the model to be estimated.}

list. Empirical mean, standard deviation and quantiles for each variable.

list. Empirical mean, standard deviation and quantiles for each variable.
}
\description{
Markov Chain Monte Carlo (MCMC) to run time-varying Bayesian split population survival model with spatial frailties.

Returns a summary of a exchangeSPsurv object via \code{\link[coda]{summary.mcmc}}.

Print method for a \code{\link{spatialSPsurv}} x.

Returns a plot of a spatialSPsurv object via \code{\link[coda]{plot.mcmc}}.
}
\examples{
\donttest{
walter <- spduration::add_duration(Walter_2015_JCR,"renewed_war",
                                   unitID = "ccode", tID = "year",
                                   freq = "year", ongoing = FALSE)

walter <- spatial_SA(data = walter, var_ccode = "ccode", threshold = 800L)

set.seed(123456)

model <-
    spatialSPsurv(
        duration  = duration ~ fhcompor1 + lgdpl + comprehensive + victory +
                    instabl + intensityln + ethfrac + unpko,
        immune    = cured ~ fhcompor1 + lgdpl + victory,
        Y0        = 't.0',
        LY        = 'lastyear',
        S         = 'sp_id' ,
        data      = walter[[1]],
        N         = 100,
        burn      = 10,
        thin      = 10,
        w         = c(1,1,1),
        m         = 10,
        form      = "Weibull",
        prop.varV = 1e-05,
        prop.varW = 1e-05,
        A         = walter[[2]]
    )

print(model)

summary(model, parameter = "betas")

# plot(model)

}
}
