% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_BayesMassBal.R
\name{plot.BayesMassBal}
\alias{plot.BayesMassBal}
\title{Plots BayesMassBal Object}
\usage{
\method{plot}{BayesMassBal}(
  x,
  sample.params = NA,
  layout = c("trace", "dens"),
  hdi.params = c(1, 0.95),
  ...
)
}
\arguments{
\item{x}{A \code{BayesMassBal} object returned from the \code{\link{BMB}} function}

\item{sample.params}{List to be used for indicating model parameter samples used for creation of plot(s).  See details for required structure.}

\item{layout}{Character string indicating the desired data to be plotted.  \code{"trace"} produces trace plots of sequential parameter draws. \code{"dens"} produces densities of posterior draws.  Argument ignored when \code{x$type = "time-series"}.}

\item{hdi.params}{Numeric vector of length two, used to draw Highest Posterior Density Intervals (HPDI) using \code{\link[HDInterval]{hdi}}, and otherwise ignored. \code{hdi.params[1] = 1} indicates \code{\link[HDInterval]{hdi}} bounds should be drawn.  The second element of \code{hdi} is passed to \code{credMass} in the \code{\link[HDInterval]{hdi}} function.  The default, \code{hdi.params = c(1,0.95)}, plots the 95\% HPDI bounds.}

\item{...}{Passes extra arguments to \code{plot()}}
}
\value{
Plots \code{BayesMassBal} object based on arguments passed to \code{plot}.
}
\description{
Visualizes data from a \code{BayesMassBal} class object in a user specified way.  Options include trace plots, posterior densities, and main effects plots.  Meant to be a quick diagnostic tool, and not to produce publication quality plots.
}
\details{
The list of \code{sample.params} requires a specific structure dependent on the choice of \code{layout} and the desired plots.

If \code{layout = "trace"} or \code{layout = "dens"}, \code{names(list)} must contain each model parameter desired for plotting.  The structure under the model parameter names must be the same as to the structure of the relevant subset of the \code{BayesMassBal} object to be used.  For example, if a \code{BayesMassBal} object is created using a process with sample components \code{c("CuFeS2","gangue")} and the users wants plots of reconciled masses \eqn{y_1} and \eqn{y_2} for both components to be created, \code{params = list(y.bal = list(CuFeS2 = c(1,2), gangue = c(1,2))} should be used.  Note, \code{str(params)} mimics \code{str(x)}, while the vectors listed simply index the desired model parameters to be plotted.

See \code{vignette("Two_Node_Process", package = "BayesMassBal")} for an example of the required structure.
}
