% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Age_OSLC14.R
\name{Age_OSLC14}
\alias{Age_OSLC14}
\title{Bayesian analysis for age estimation of OSL measerments and 14C ages of various samples}
\usage{
Age_OSLC14(DATA, Data_C14Cal, Data_SigmaC14Cal, Nb_sample, SampleNames,
  SampleNature, PriorAge = rep(c(10, 60), Nb_sample), SavePdf = FALSE,
  OutputFileName = c("MCMCplot", "HPD_Cal14CCurve", "summary"),
  OutputFilePath = c(""), SaveEstimates = FALSE,
  OutputTableName = c("DATA"), OutputTablePath = c(""),
  StratiConstraints = c(), sepSC = c(","), BinPerSample = rep(1,
  sum(SampleNature[1, ])), THETA = c(), sepTHETA = c(","), LIN_fit = TRUE,
  Origin_fit = FALSE, distribution = c("cauchy"), Model_C14 = c("full"),
  CalibrationCurve = c("AtmosphericNorth"), Iter = 50000, t = 5,
  Nb_chaines = 3)
}
\arguments{
\item{DATA}{list of objects: LT, sLT, ITimes, dLab, ddot_env, regDose, J, K, Nb_measurement,
provided by the function \code{\link{Generate_DataFile}} or \code{\link{Generate_DataFile_MG}} or \code{\link{Concat_DataFile}}.
\code{DATA} contains information for more than one sample.
If there is stratigraphic relations between samples, informations in DATA must be ordered by order of incresing ages.
See the details section to for more informations.}

\item{Data_C14Cal}{numeric vector: corresponding to 14C age estimate.
If there is stratigraphic relations between samples, \code{Data_C14Cal} must be ordered by order of incresing ages.}

\item{Data_SigmaC14Cal}{numeric vector: correponding to the error of 14C age estimates.}

\item{Nb_sample}{integer: number of samples (OSL data and 14C age),
(\code{Nb_sample>3}, at least to sample of OSL data and one sample of 14C age).}

\item{SampleNames}{character vector: sample names for both OSL data and C14 data. The length of this vector is equal to \code{Nb_sample}.
If there is stratigephic relation, this vector must be ordered by increasing order (to mix OSL samples and 14C ages if it is needed).}

\item{SampleNature}{numeric matrix: states the nature of the sample.
Row number of \code{SampleNature} matrix is equal to \code{2} and column number is equal to \code{Nb_sample}.
First line of the matrix: \code{SampleNature[1,i]} states if sample whose number ID is equal to \code{i}, is an OSL sample \bold{1} or not \bold{0}.
Second line of the matrix: \code{SampleNature[2,i]} states if sample whose number ID is equal to \code{i}, is an 14C sample \bold{1} or not \bold{0}.}

\item{PriorAge}{numeric vector (with default): lower and upper bounds for age parameter of each sample \bold{(in ka)}.
Note that, \code{length(PriorAge)=2*Nb_sample}
and \code{PriorAge[2i-1,2i]} correponds to the lower and upper bounds of sample whose number ID is equal to \code{i}.}

\item{SavePdf}{boolean (with default): if TRUE save graphs in pdf file named \code{OutputFileName} in folder \code{OutputFilePath}.}

\item{OutputFileName}{character (with default): name of the pdf file that will be generated by the function if \code{SavePdf}=TRUE,
\code{length(OutputFileName)=3}, see \bold{PLOT OUTPUT} in \bold{Value} section for more informations.}

\item{OutputFilePath}{character (with default): path to the pdf file that will be generated by the function if \code{SavePdf}=TRUE.
If it is not equal to "", it must be terminated by "/".}

\item{SaveEstimates}{boolean (with default): if TRUE save Bayes estimates, credible interval at level 68\% and 95\%  and
the result of the gelman en Rudin test of convergency, in a csv table named \code{OutputFileName} in folder \code{OutputFilePath}.}

\item{OutputTableName}{character (with default): name of the table that will be generated by the function if \code{SaveEstimates}=TRUE.}

\item{OutputTablePath}{character (with default): path to the table that will be generated by the function if \code{SaveEstimates}=TRUE.
If it is not equal to "", it must be terminated by "/".}

\item{StratiConstraints}{numeric matrix or character(with default): input object for the statigraphic relation between samples.
If there is stratigraphic relation between samples see the details section for instructions regarding how to correctly fill \code{StratiConstraints},
the user can refer to a matrix (numeric matrix) or to a csv file (character).
Otherwise, default value is suitable.}

\item{sepSC}{character (with default): if \code{StratiConstraints} is character,
indicate column separator in \code{StratiConstraints} csv file.}

\item{BinPerSample}{integer vector (with default): vector with the number of BIN files per OSL sample.
The length of this vector is equal to the number of OSL samples.
\code{BinPerSample}[i] correponds to the number of BIN files for the sample whose number ID is equal to \code{i}.
For more information to fill this vector, we refer to detatils in \code{\link{Generate_DataFile}} or in \code{\link{Generate_DataFile_MG}}.}

\item{THETA}{numeric matrix or character (with default): input object for systematic and individual error for OSL samples.
If systematic errors are considered, see the details section for instructions regarding how to correctly fill \code{THETA};
the user can refer to a matrix (numeric matrix) or to a csv file (character).
Otherwise, default value is suitable, and only individual error is considered.}

\item{sepTHETA}{character (with default): if \code{THETA} is character,
indicate column separator in \code{THETA} csv file.}

\item{LIN_fit}{logical (with default): if TRUE (default) allows a linear component,
on top of the (default) saturating exponential curve, for the fitting of dose response curves, for OSL samples.
See details for more informations on the proposed dose response curves.}

\item{Origin_fit}{logical (with default): if TRUE, forces the dose response curves to pass through the origin.
See details for more informations on the proposed growth curves, for OSL samples.}

\item{distribution}{character (with default): type of distribution that defines
how individual equivalent dose values are distributed around the palaeodose, for OSL samples.
Allowed inputs are \bold{"cauchy"}, \bold{"gaussian"}, \bold{"lognormal_A"} and \bold{"lognormal_M"}, see details for more informations.}

\item{Model_C14}{character (with default): if \bold{"full"}, error on estimate calibration curve is taken account, for 14C samples.
If \bold{"naive"} this error is not taken account in the age estimate.}

\item{CalibrationCurve}{character (with default): calibration curve choosen, for 14C samples. Allowed inputs are
\itemize{
  \item \bold{"AtmosphericNorth"} for Northern Hemisphere atmospheric radiocarbon calibration curve,
  \item \bold{"Marine"} for Marine radiocarbon calibration curve,
  \item \bold{"AtmosphericSouth"} for Southern Hemisphere atmospheric radiocarbon calibration curve,
  \item \bold{a csv file, with tree columns, the first column is dedicated to "Cal.BP", the second to "X14C.age", the third to "Error".
  The decimal of this file must be a dot, and the separator must be a comma. }
}}

\item{Iter}{integer (with default): number of iterations for the MCMC computation (for more information see \code{\link{jags.model}}).}

\item{t}{integer (with default): 1 every \code{t} iterations of the MCMC is considered for sampling the posterior distribution
(for more information see \code{\link{jags.model}}).}

\item{Nb_chaines}{integer (with default): number of independent chains for the model (for more information see \code{\link{jags.model}}).}
}
\value{
\bold{NUMERICAL OUTPUT}\cr

\enumerate{
\item \bold{A list containing the following objects:}
 \itemize{
  \item \bold{Sampling}: that corresponds to a sample of the posterior distributions of the age parameters;
  \item \bold{PriorAge}: stating the priors used for the age parameter;
  \item \bold{StratiConstraints}: stating the stratigraphic relations between samples considered in the model;
  \item \bold{Model_OSL_GrowthCurve}: stating which dose response fitting option was chosen;
  \item \bold{Model_OSL_Distribution}: stating which distribution was chosen to model the dispersion of
 individual equivalent dose values around the palaeodose of the sample;
  \item \bold{Model_C14}: stating which model was chosen (\code{"full"} or \code{"naive"});
  \item \bold{CalibrationCurve}: stating which radiocarbon calibration curve was chosen;
  \item \bold{Outlier}: stating the names of samples that must be outliers.
 }

  \item \bold{The Gelman and Rudin test of convergency}: prints the result of the Gelman and Rudin test of convergency for the age estimate for each sample.
A result close to one is expected.\cr
In addition, the user must visually assess the convergency of the trajectories by looking at the graph
generated by the function (see \bold{PLOT OUTPUT} for more informations).\cr
If both convergencies (Gelman and Rudin test and plot checking) are satisfactory,
the user can consider the estimates as valid.
Otherwise, the user may try increasing the number of MCMC interations (\code{Iter})
or be more precise on the \code{PriorAge} parameter to reach convergency.
  \item \bold{Credible intervals and Bayes estimates}: prints the Bayes esitmates, the credible intervals at 95\% and 68\% for
the age parameters for each sample.
}

\bold{PLOT OUTPUT}

\enumerate{
 \item\bold{MCMC trajectories}: A graph with the MCMC trajectories and posterior distributions of the age parameter is displayed. \cr
On each line, the plot on the left represents the MCMC trajectories, and the one on the right the posterior distribution of the parameter.
 \item \bold{Age estimate and HPD at 95\% of 14C samples on calibration curve}: plot age estimate and HPD on calibration plot.
 \item \bold{Summary of sample age estimates}: plot credible intervals and Bayes estimate of each sample age on a same graph.
}
}
\description{
This function compute an age of OSL data of at least two samples and calibrate 14C ages of samples to get an age (in ka).\cr
Age of OSL data are computed according to the model given in Combes and Philippe (2017).
Single-grain or Multi-grain OSL measurements can be analysed simultaneouly (with output of \code{\link{Generate_DataFile}}
or \code{\link{Generate_DataFile_MG}} or both of them using \code{\link{Concat_DataFile}}).
Samples, for which data is avalilable in several BIN files, can be analysed.\cr
For C14 data, the user can choose one of the following radiocarbon calibration curve:
Northern or Sourthen Hemisphere or marine atmospheric.
}
\details{
Note that there is tree type of arguments in the previous list.
There are arguments for informtations concerning only OSL samples: \code{DATA}, \code{BinPerSample}, \code{THETA},
\code{sepTHETA}, \code{LIN_fit}, \code{Origin_fit}, \code{distribution}.

There are arguments for informtations concerning only C14 samples: \code{Data_C14Cal}, \code{Data_SigmaC14Cal},
\code{Model_C14}, \code{CalibrationCurve}.

There are arguments for informtations concerning all the samples: \code{Nb_sample}, \code{SampleNames}, \code{SampleNature},
\code{PriorAge}, \code{SavePdf}, \code{OutputFileName}, \code{OutputFilePath}, \code{SaveEstimates}, \code{OutputTableName},
\code{OutputTablePath}, \code{StratiConstraints}, \code{sepSC}.\cr

\bold{** How to fill} \code{StratiConstraints} \bold{? **}\cr

If there is stratigraphic relations between samples, \bold{14C estimate age in \code{Data_C14Cal} must be ordered by order of increasing ages,
as informations in \code{DATA}}. Names in \code{SampleNames} must be ordered and correponds to the order in \code{Data_C14Cal} and in \code{DATA},
also if it is needed to mix names of OSL samples and 14C samples.

The user can fill the \code{StratiConstraints} matrix as follow.
\enumerate{
 \item \bold{Size of the matrix}: row number of \code{StratiConstraints} matrix is equal to \code{Nb_sample+1},
and column number is equal to \code{Nb_sample}.
 \item \bold{First line of the matrix}:
for all \code{i in {1,...,Nb_Sample}}, \code{StratiConstraints[1,i]=1} that means the lower bound of the sample age (given in \code{PriorAge[2i-1]})
for the sample whose number ID is equal to \code{i}, is taken into account.
 \item \bold{Sample relations}: for all  \code{j in {2,...,Nb_Sample+1}} and all \code{i in {j,...,Nb_Sample}},
\code{StratiConstraints[j,i]=1} if sample age whose number ID is equal to \code{j-1} is lower than sample age whose number ID is equal to \code{i}.
Otherwise, \code{StratiConstraints[j,i]=0}.
}
Note that \code{StratiConstraints_{2:Nb_sample+1,1:Nb_sample}} is a upper triangular matrix.

The user can also use \code{\link{SCMatrix}}  or \code{\link{SC_Ordered}} (if all samples are ordered) function to construc
the \code{StratiConstraints} matrix.

The user can also refer to a csv file that containts the relation between samples as defined above.
The user must take care about the separator used in the csv file using the argument \code{sepSC}.\cr

 \bold{** How to fill} \code{THETA} \bold{covariance matrix concerning common and individual error? **}\cr

If systematic errors are considered, the user can fill the \code{THETA} matrix as follow.
\itemize{
 \item row number of \code{THETA} is equal the column number, equal to \code{Nb_sample}.
 \item For all \code{i in {1,...,Nb_sample}}, \code{THETA[i,i]} containts individual error
 plus systematic error of the sample whose number ID is equal to \code{i}.
 \item For all \code{i,j in {1,...,Nb_sample}} and \code{i} different from \code{j} ,
\code{THETA[i,j]} containts common error between samples whose number ID are equal to \code{i} and \code{j}.
}
Note that \code{THETA[i,j]} is a symetric matrix.

The user can also refer to a .csv file that containts the errors as defined above.\cr

\bold{** Option on growth curves **}\cr

As for \code{\link{Age_Computation}} and \code{\link{Palaeodose_Computation}}, the user can choose from 4 dose response curves:
\itemize{
  \item \bold{Saturating exponential plus linear growth} (\code{AgesMultiCS2_EXPLIN}):

  for all \code{x} in IR+, \code{f(x)=a(1-exp(-x/b))+cx+d}; select
  \itemize{
    \item \code{LIN_fit=TRUE}
    \item \code{Origin_fit=FALSE}
  }
  \item \bold{Saturating exponential growth} (\code{AgesMultiCS2_EXP}):

  for all \code{x} in IR+, \code{f(x)=a(1-exp(-x/b))+d}; select
  \itemize{
    \item \code{LIN_fit=FALSE}
    \item \code{Origin_fit=FALSE}
  }
  \item \bold{Saturating exponential plus linear growth and fitting through the origin} (\code{AgesMultiCS2_EXPLINZO}):

  for all \code{x} in IR+, \code{f(x)=a(1-exp(-x/b))+cx}; select
  \itemize{
    \item \code{LIN_fit=TRUE}
    \item \code{Origin_fit=TRUE}
  }
  \item \bold{Saturating exponential growth and fitting through the origin} (\code{AgesMultiCS2_EXPZO}):

  for all \code{x} in IR+, \code{f(x)=a(1-exp(-x/b))}; select
  \itemize{
    \item \code{LIN_fit=FALSE}
    \item \code{Origin_fit=TRUE}
  }
}

\bold{** Option on equivalent dose distribution around the palaeodose **}\cr

The use can choose between :
\itemize{
  \item \code{cauchy}: a Cauchy distribution with location parameter equal to the palaeodose of the sample
  \item \code{gaussian}: a Gaussian distribution with mean equal to the palaeodose of the sample
  \item \code{lognormal_A}: a log-normal distribution with mean or \bold{A}verage equal to the palaeodose of the sample
  \item \code{lognormal_M}: a log-normal distribution with \bold{M}edian equal to the palaeodose of the sample
}

\bold{** More precision on \code{Model} **}\cr

We propose two models "full" or "naive". If \code{Model='full'} that means measurement error and error on calibration curve are taken account in
the Bayesian model; if \code{Model="naive"} that means only error on measurement are taken account in the mode.

More precisely, the model considered here, as the one developped by Christen, JA (1994), assume multiplicative effect of errors to address the
problem of outliers. In addition, to not penalyse variables that are not outliers and damage theirs estimation,
we introduce a structure of mixture, that means only variable that are considered as outlier have in addition a multiplicative error.
}
\examples{
## Load data
# OSL data
data(DATA1,envir = environment())
data(DATA2,envir = environment())
Data=Concat_DataFile(DATA2,DATA1)

# 14C data
C14Cal=DATA_C14$C14[1,1]
SigmaC14Cal=DATA_C14$C14[1,2]
Names=DATA_C14$Names[1]

# Prior Age
prior=rep(c(1,60),3)
samplenature=matrix(data=c(1,0,1,0,1,0),ncol=3,nrow=2,byrow=TRUE)
SC=matrix(data=c(1,1,1,0,1,1,0,0,1,0,0,0),ncol=3,nrow=4,byrow=TRUE)
## Age computation of samples
Age=Age_OSLC14(DATA=Data,Data_C14Cal=C14Cal,Data_SigmaC14Cal=SigmaC14Cal,
   SampleNames=c("GDB5",Names,"GDB3"),Nb_sample=3,SampleNature=samplenature,
   PriorAge=prior,StratiConstraints=SC,Iter=50,Nb_chaines=2)
}
\references{
Reimer PJ, Bard E, Bayliss A, Beck JW, Blackwell PC, Bronl Ramsey C, Buck CE, Cheng H, Edwards RL, Friedrich M,
Grootes PM, Guilderson TP, Haflidason H, Hajdas I, Hatte C, Heaton TJ, Hoffmann DL, Hogg AG, Hughen KA, Kaiser KF, Kromer B,
Manning SW, Niu M, Reimer RW, Richards DA, Scott EM, Southon JR, Staff RA, Turney CSM, van der Plicht J. 2013.
IntCal13 ans Marine13 radiocarbon age calibration curves 0-50000 years cal BP. Radiocarbon 55(4)=1869-1887.

Hogg AG, Hua Q, Blackwell PG, Niu M, Buck CE, Guilderson TP, Heaton TJ, Palmer JG, Reimer PJ, Reimer RW, Turney CSM, Zimmerman SRH.
2013. SHCal13 Southern Hemisphere calibration, 0-50000 years cal BP. Radiocarbon 55(4):1889-1903
}
\seealso{
\code{\link{rjags}}, \code{\link{MCMC_plot}}, \code{\link{SCMatrix}}
}
\author{
Claire Christophe, Anne Philippe, Guillaume Guerin
}
